/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Collection;
import java.util.Map;
import java.util.function.ToIntFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ArrayUtils {
    private ArrayUtils() {
    }

    public static boolean isEmpty(@Nullable Object @NotNull [] array) {
        for (Object object : array) {
            if (object == null) continue;
            return false;
        }
        return true;
    }

    public static int[] concatenateIntArrays(int[] ... arrays) {
        int totalLength = 0;
        for (int[] array : arrays) {
            totalLength += array.length;
        }
        int[] result2 = new int[totalLength];
        int startingPos = 0;
        for (int[] array : arrays) {
            System.arraycopy(array, 0, result2, startingPos, array.length);
            startingPos += array.length;
        }
        return result2;
    }

    public static <T> int[] mapToIntArray(Collection<T> collection, ToIntFunction<T> function) {
        int size = collection.size();
        if (size == 0) {
            return new int[0];
        }
        int[] result2 = new int[size];
        int i = 0;
        for (T object : collection) {
            result2[i++] = function.applyAsInt(object);
        }
        assert (i == size);
        return result2;
    }

    public static <K, V> Map<K, V> toMap(@NotNull K[] keys2, @NotNull V[] values2, int length) {
        assert (keys2.length >= length && keys2.length == values2.length);
        return switch (length) {
            case 0 -> Map.of();
            case 1 -> Map.of(keys2[0], values2[0]);
            case 2 -> Map.of(keys2[0], values2[0], keys2[1], values2[1]);
            case 3 -> Map.of(keys2[0], values2[0], keys2[1], values2[1], keys2[2], values2[2]);
            case 4 -> Map.of(keys2[0], values2[0], keys2[1], values2[1], keys2[2], values2[2], keys2[3], values2[3]);
            case 5 -> Map.of(keys2[0], values2[0], keys2[1], values2[1], keys2[2], values2[2], keys2[3], values2[3], keys2[4], values2[4]);
            case 6 -> Map.of(keys2[0], values2[0], keys2[1], values2[1], keys2[2], values2[2], keys2[3], values2[3], keys2[4], values2[4], keys2[5], values2[5]);
            case 7 -> Map.of(keys2[0], values2[0], keys2[1], values2[1], keys2[2], values2[2], keys2[3], values2[3], keys2[4], values2[4], keys2[5], values2[5], keys2[6], values2[6]);
            case 8 -> Map.of(keys2[0], values2[0], keys2[1], values2[1], keys2[2], values2[2], keys2[3], values2[3], keys2[4], values2[4], keys2[5], values2[5], keys2[6], values2[6], keys2[7], values2[7]);
            case 9 -> Map.of(keys2[0], values2[0], keys2[1], values2[1], keys2[2], values2[2], keys2[3], values2[3], keys2[4], values2[4], keys2[5], values2[5], keys2[6], values2[6], keys2[7], values2[7], keys2[8], values2[8]);
            case 10 -> Map.of(keys2[0], values2[0], keys2[1], values2[1], keys2[2], values2[2], keys2[3], values2[3], keys2[4], values2[4], keys2[5], values2[5], keys2[6], values2[6], keys2[7], values2[7], keys2[8], values2[8], keys2[9], values2[9]);
            default -> Map.copyOf(new Object2ObjectArrayMap(keys2, values2, length));
        };
    }
}

