/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.thread;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import net.minestom.server.MinecraftServer;
import net.minestom.server.Tickable;
import net.minestom.server.thread.MinestomThread;
import net.minestom.server.thread.ThreadDispatcher;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class TickThread
extends MinestomThread {
    private final ReentrantLock lock = new ReentrantLock();
    private volatile boolean stop;
    private CountDownLatch latch;
    private long tickTime;
    private final List<ThreadDispatcher.Partition> entries = new ArrayList<ThreadDispatcher.Partition>();

    public TickThread(int number) {
        super("Ms-Tick-" + number);
    }

    @Override
    public void run() {
        LockSupport.park(this);
        while (!this.stop) {
            this.lock.lock();
            try {
                this.tick();
            }
            catch (Exception e) {
                MinecraftServer.getExceptionManager().handleException(e);
            }
            this.lock.unlock();
            this.latch.countDown();
            LockSupport.park(this);
        }
    }

    private void tick() {
        ReentrantLock lock = this.lock;
        long tickTime = this.tickTime;
        for (ThreadDispatcher.Partition entry2 : this.entries) {
            assert (entry2.thread() == this);
            List<Tickable> elements = entry2.elements();
            if (elements.isEmpty()) continue;
            for (Tickable element : elements) {
                if (lock.hasQueuedThreads()) {
                    lock.unlock();
                    lock.lock();
                }
                try {
                    element.tick(tickTime);
                }
                catch (Throwable e) {
                    MinecraftServer.getExceptionManager().handleException(e);
                }
            }
        }
    }

    void startTick(CountDownLatch latch, long tickTime) {
        if (this.entries.isEmpty()) {
            latch.countDown();
            return;
        }
        this.latch = latch;
        this.tickTime = tickTime;
        this.stop = false;
        LockSupport.unpark(this);
    }

    public Collection<ThreadDispatcher.Partition> entries() {
        return this.entries;
    }

    @NotNull
    public ReentrantLock lock() {
        return this.lock;
    }

    void shutdown() {
        this.stop = true;
        LockSupport.unpark(this);
    }
}

