/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.thread;

import java.util.concurrent.locks.LockSupport;
import net.minestom.server.MinecraftServer;
import net.minestom.server.ServerProcess;
import net.minestom.server.thread.MinestomThread;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class TickSchedulerThread
extends MinestomThread {
    private final ServerProcess serverProcess;

    public TickSchedulerThread(ServerProcess serverProcess) {
        super("Ms-TickScheduler");
        this.serverProcess = serverProcess;
    }

    @Override
    public void run() {
        long tickNs = (long)((double)MinecraftServer.TICK_MS * 1000000.0);
        while (this.serverProcess.isAlive()) {
            long tickStart = System.nanoTime();
            try {
                this.serverProcess.ticker().tick(tickStart);
            }
            catch (Exception e) {
                this.serverProcess.exception().handleException(e);
            }
            long wait = tickStart + tickNs - System.nanoTime();
            assert (wait <= tickNs) : "Wait time is too long: " + (double)wait / 1000000.0 + "ms";
            LockSupport.parkNanos(wait);
        }
    }
}

