/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.thread;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import net.minestom.server.Tickable;
import net.minestom.server.entity.Entity;
import net.minestom.server.thread.AcquirableImpl;
import net.minestom.server.thread.ThreadProvider;
import net.minestom.server.thread.TickThread;
import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.MpscUnboundedArrayQueue;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class ThreadDispatcher<P> {
    private final ThreadProvider<P> provider;
    private final List<TickThread> threads;
    private final Map<P, Partition> partitions = new WeakHashMap<P, Partition>();
    private final Map<Tickable, Partition> elements = new WeakHashMap<Tickable, Partition>();
    private final ArrayDeque<P> partitionUpdateQueue = new ArrayDeque();
    private final MessagePassingQueue<DispatchUpdate<P>> updates = new MpscUnboundedArrayQueue<DispatchUpdate<P>>(1024);

    private ThreadDispatcher(ThreadProvider<P> provider, int threadCount) {
        this.provider = provider;
        TickThread[] threads = new TickThread[threadCount];
        Arrays.setAll(threads, TickThread::new);
        this.threads = List.of(threads);
        this.threads.forEach(Thread::start);
    }

    @NotNull
    public static <P> ThreadDispatcher<P> of(@NotNull ThreadProvider<P> provider, int threadCount) {
        return new ThreadDispatcher<P>(provider, threadCount);
    }

    @NotNull
    public static <P> ThreadDispatcher<P> singleThread() {
        return ThreadDispatcher.of(ThreadProvider.counter(), 1);
    }

    @NotNull
    public @Unmodifiable @NotNull List<@NotNull TickThread> threads() {
        return this.threads;
    }

    public synchronized void updateAndAwait(long time) {
        this.updates.drain(update2 -> {
            if (update2 instanceof DispatchUpdate.PartitionLoad) {
                DispatchUpdate.PartitionLoad chunkUpdate = (DispatchUpdate.PartitionLoad)update2;
                this.processLoadedPartition(chunkUpdate.partition());
            } else if (update2 instanceof DispatchUpdate.PartitionUnload) {
                DispatchUpdate.PartitionUnload partitionUnload = (DispatchUpdate.PartitionUnload)update2;
                this.processUnloadedPartition(partitionUnload.partition());
            } else if (update2 instanceof DispatchUpdate.ElementUpdate) {
                DispatchUpdate.ElementUpdate elementUpdate = (DispatchUpdate.ElementUpdate)update2;
                this.processUpdatedElement(elementUpdate.tickable(), elementUpdate.partition());
            } else if (update2 instanceof DispatchUpdate.ElementRemove) {
                DispatchUpdate.ElementRemove elementRemove = (DispatchUpdate.ElementRemove)update2;
                this.processRemovedElement(elementRemove.tickable());
            } else {
                throw new IllegalStateException("Unknown update type: " + update2.getClass().getSimpleName());
            }
        });
        CountDownLatch latch = new CountDownLatch(this.threads.size());
        for (TickThread thread2 : this.threads) {
            thread2.startTick(latch, time);
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void refreshThreads(long nanoTimeout) {
        block0 : switch (this.provider.refreshType()) {
            case NEVER: {
                break;
            }
            case ALWAYS: {
                P partition;
                long currentTime = System.nanoTime();
                int counter = this.partitionUpdateQueue.size();
                while ((partition = this.partitionUpdateQueue.pollFirst()) != null) {
                    Partition partitionEntry = this.partitions.get(partition);
                    assert (partitionEntry != null);
                    TickThread previous = partitionEntry.thread;
                    TickThread next = this.retrieveThread(partition);
                    if (next != previous) {
                        partitionEntry.thread = next;
                        previous.entries().remove(partitionEntry);
                        next.entries().add(partitionEntry);
                    }
                    this.partitionUpdateQueue.addLast(partition);
                    if (--counter > 0 && System.nanoTime() - currentTime < nanoTimeout) continue;
                    break block0;
                }
                break;
            }
        }
    }

    public void refreshThreads() {
        this.refreshThreads(Long.MAX_VALUE);
    }

    public void createPartition(P partition) {
        this.signalUpdate(new DispatchUpdate.PartitionLoad<P>(partition));
    }

    public void deletePartition(P partition) {
        this.signalUpdate(new DispatchUpdate.PartitionUnload<P>(partition));
    }

    public void updateElement(Tickable tickable, P partition) {
        this.signalUpdate(new DispatchUpdate.ElementUpdate<P>(tickable, partition));
    }

    public void removeElement(Tickable tickable) {
        this.signalUpdate(new DispatchUpdate.ElementRemove(tickable));
    }

    public void shutdown() {
        this.threads.forEach(TickThread::shutdown);
    }

    private TickThread retrieveThread(P partition) {
        int threadId = this.provider.findThread(partition);
        int index = Math.abs(threadId) % this.threads.size();
        return this.threads.get(index);
    }

    private void signalUpdate(@NotNull DispatchUpdate<P> update2) {
        this.updates.relaxedOffer(update2);
    }

    private void processLoadedPartition(P partition) {
        if (this.partitions.containsKey(partition)) {
            return;
        }
        TickThread thread2 = this.retrieveThread(partition);
        Partition partitionEntry = new Partition(thread2);
        thread2.entries().add(partitionEntry);
        this.partitions.put(partition, partitionEntry);
        this.partitionUpdateQueue.add(partition);
        if (partition instanceof Tickable) {
            Tickable tickable = (Tickable)partition;
            this.processUpdatedElement(tickable, partition);
        }
    }

    private void processUnloadedPartition(P partition) {
        Partition partitionEntry = this.partitions.remove(partition);
        if (partitionEntry != null) {
            TickThread thread2 = partitionEntry.thread;
            thread2.entries().remove(partitionEntry);
        }
        this.partitionUpdateQueue.remove(partition);
        if (partition instanceof Tickable) {
            Tickable tickable = (Tickable)partition;
            this.processRemovedElement(tickable);
        }
    }

    private void processRemovedElement(Tickable tickable) {
        Partition partition = this.elements.get(tickable);
        if (partition != null) {
            partition.elements.remove(tickable);
        }
    }

    private void processUpdatedElement(Tickable tickable, P partition) {
        Partition partitionEntry = this.elements.get(tickable);
        if (partitionEntry != null) {
            partitionEntry.elements.remove(tickable);
        }
        if ((partitionEntry = this.partitions.get(partition)) != null) {
            this.elements.put(tickable, partitionEntry);
            partitionEntry.elements.add(tickable);
            if (tickable instanceof Entity) {
                Entity entity = (Entity)tickable;
                ((AcquirableImpl)entity.getAcquirable()).updateThread(partitionEntry.thread());
            }
        }
    }

    public static final class Partition {
        private TickThread thread;
        private final List<Tickable> elements = new ArrayList<Tickable>();

        private Partition(TickThread thread2) {
            this.thread = thread2;
        }

        @NotNull
        public TickThread thread() {
            return this.thread;
        }

        @NotNull
        public List<Tickable> elements() {
            return this.elements;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @ApiStatus.Internal
    static interface DispatchUpdate<P> {

        public record ElementRemove<P>(@NotNull Tickable tickable) implements DispatchUpdate<P>
        {
        }

        public record ElementUpdate<P>(@NotNull Tickable tickable, P partition) implements DispatchUpdate<P>
        {
        }

        public record PartitionUnload<P>(@NotNull P partition) implements DispatchUpdate<P>
        {
        }

        public record PartitionLoad<P>(@NotNull P partition) implements DispatchUpdate<P>
        {
        }
    }
}

