/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.thread;

import java.lang.invoke.VarHandle;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import net.minestom.server.thread.Acquirable;
import net.minestom.server.thread.TickThread;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AcquirableImpl<T>
implements Acquirable<T> {
    static final AtomicLong WAIT_COUNTER_NANO = new AtomicLong();
    private static final ReentrantLock GLOBAL_LOCK = new ReentrantLock();
    private final T value;
    private TickThread assignedThread;

    public AcquirableImpl(@NotNull T value) {
        this.value = value;
    }

    @Override
    @NotNull
    public T unwrap() {
        return this.value;
    }

    @Override
    @NotNull
    public TickThread assignedThread() {
        VarHandle.acquireFence();
        return this.assignedThread;
    }

    void updateThread(@NotNull TickThread thread2) {
        this.assignedThread = thread2;
        VarHandle.releaseFence();
    }

    @Nullable
    static ReentrantLock enter(@NotNull Thread currentThread, @Nullable TickThread elementThread) {
        if (elementThread == null) {
            return null;
        }
        if (currentThread == elementThread) {
            return null;
        }
        ReentrantLock currentLock = currentThread instanceof TickThread ? ((TickThread)currentThread).lock() : null;
        ReentrantLock targetLock = elementThread.lock();
        if (targetLock.isHeldByCurrentThread()) {
            return null;
        }
        long time = System.nanoTime();
        if (currentLock != null) {
            while (!GLOBAL_LOCK.tryLock()) {
                currentLock.unlock();
                currentLock.lock();
            }
        } else {
            GLOBAL_LOCK.lock();
        }
        targetLock.lock();
        WAIT_COUNTER_NANO.addAndGet(System.nanoTime() - time);
        return targetLock;
    }

    static void leave(@Nullable ReentrantLock lock) {
        if (lock != null) {
            lock.unlock();
            GLOBAL_LOCK.unlock();
        }
    }
}

