/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.terminal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.format.NamedTextColor;
import net.minestom.server.utils.PropertyUtils;

final class TerminalColorConverter {
    private static final boolean SUPPORT_HEX_COLOR = PropertyUtils.getBoolean("minestom.terminal.support-hex-color", true);
    private static final boolean SUPPORT_COLOR = PropertyUtils.getBoolean("minestom.terminal.support-color", true);
    private static final String RGB_ANSI = "\u001b[38;2;%d;%d;%dm";
    private static final String ANSI_RESET = "\u001b[m";
    private static final String LOOKUP = "0123456789abcdefklmnor";
    private static final String[] ANSI_CODES = new String[]{TerminalColorConverter.getAnsiColor(NamedTextColor.BLACK, "\u001b[0;30m"), TerminalColorConverter.getAnsiColor(NamedTextColor.DARK_BLUE, "\u001b[0;34m"), TerminalColorConverter.getAnsiColor(NamedTextColor.DARK_GREEN, "\u001b[0;32m"), TerminalColorConverter.getAnsiColor(NamedTextColor.DARK_AQUA, "\u001b[0;36m"), TerminalColorConverter.getAnsiColor(NamedTextColor.DARK_RED, "\u001b[0;31m"), TerminalColorConverter.getAnsiColor(NamedTextColor.DARK_PURPLE, "\u001b[0;35m"), TerminalColorConverter.getAnsiColor(NamedTextColor.GOLD, "\u001b[0;33m"), TerminalColorConverter.getAnsiColor(NamedTextColor.GRAY, "\u001b[0;37m"), TerminalColorConverter.getAnsiColor(NamedTextColor.DARK_GRAY, "\u001b[0;30;1m"), TerminalColorConverter.getAnsiColor(NamedTextColor.BLUE, "\u001b[0;34;1m"), TerminalColorConverter.getAnsiColor(NamedTextColor.GREEN, "\u001b[0;32;1m"), TerminalColorConverter.getAnsiColor(NamedTextColor.AQUA, "\u001b[0;36;1m"), TerminalColorConverter.getAnsiColor(NamedTextColor.RED, "\u001b[0;31;1m"), TerminalColorConverter.getAnsiColor(NamedTextColor.LIGHT_PURPLE, "\u001b[0;35;1m"), TerminalColorConverter.getAnsiColor(NamedTextColor.YELLOW, "\u001b[0;33;1m"), TerminalColorConverter.getAnsiColor(NamedTextColor.WHITE, "\u001b[0;37;1m"), "\u001b[5m", "\u001b[1m", "\u001b[9m", "\u001b[4m", "\u001b[3m", "\u001b[m"};
    private static final Pattern RGB_PATTERN = Pattern.compile("\u00a7#([\\da-fA-F]{6})");
    private static final Pattern NAMED_PATTERN = Pattern.compile("\u00a7([\\da-fk-orA-FK-OR])");

    private TerminalColorConverter() {
    }

    private static String getAnsiColor(NamedTextColor color, String fallback) {
        return TerminalColorConverter.getAnsiColorFromHexColor(color.value(), fallback);
    }

    private static String getAnsiColorFromHexColor(int color, String fallback) {
        return SUPPORT_HEX_COLOR ? String.format(RGB_ANSI, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF) : fallback;
    }

    private static String getAnsiColorFromHexColor(int color) {
        return TerminalColorConverter.getAnsiColorFromHexColor(color, "");
    }

    public static String format(String string) {
        if (string.indexOf(167) == -1) {
            return string;
        }
        string = RGB_PATTERN.matcher(string).replaceAll(match -> {
            if (SUPPORT_COLOR) {
                String hex = match.group(1);
                return TerminalColorConverter.getAnsiColorFromHexColor(Integer.parseInt(hex, 16));
            }
            return "";
        });
        Matcher matcher = NAMED_PATTERN.matcher(string);
        StringBuilder builder = new StringBuilder();
        while (matcher.find()) {
            int format = LOOKUP.indexOf(Character.toLowerCase(matcher.group().charAt(1)));
            if (format != -1) {
                matcher.appendReplacement(builder, SUPPORT_COLOR ? ANSI_CODES[format] : "");
                continue;
            }
            matcher.appendReplacement(builder, matcher.group());
        }
        matcher.appendTail(builder);
        if (SUPPORT_COLOR) {
            builder.append(ANSI_RESET);
        }
        return builder.toString();
    }
}

