/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.terminal;

import java.io.IOException;
import java.util.List;
import net.minestom.server.MinecraftServer;
import net.minestom.server.command.CommandManager;
import net.minestom.server.command.ConsoleSender;
import net.minestom.server.command.builder.Command;
import net.minestom.server.command.builder.suggestion.Suggestion;
import net.minestom.server.command.builder.suggestion.SuggestionEntry;
import net.minestom.server.listener.TabCompleteListener;
import org.jetbrains.annotations.ApiStatus;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.ParsedLine;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class MinestomTerminal {
    private static final String PROMPT = "> ";
    private static volatile Terminal terminal;
    static volatile LineReader reader;
    private static volatile boolean running;

    @ApiStatus.Internal
    public static void start() {
        Thread thread2 = new Thread(null, () -> {
            try {
                terminal = TerminalBuilder.terminal();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            reader = LineReaderBuilder.builder().completer(new MinestomCompleter()).terminal(terminal).build();
            running = true;
            while (running) {
                try {
                    String command2 = reader.readLine(PROMPT);
                    CommandManager commandManager = MinecraftServer.getCommandManager();
                    commandManager.execute(commandManager.getConsoleSender(), command2);
                }
                catch (UserInterruptException e) {
                    System.exit(0);
                    return;
                }
                catch (EndOfFileException e) {
                    return;
                }
            }
        }, "Jline");
        thread2.setDaemon(true);
        thread2.start();
    }

    @ApiStatus.Internal
    public static void stop() {
        running = false;
        if (terminal != null) {
            try {
                terminal.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            reader = null;
        }
    }

    static {
        running = false;
    }

    private static final class MinestomCompleter
    implements Completer {
        private MinestomCompleter() {
        }

        @Override
        public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
            CommandManager commandManager = MinecraftServer.getCommandManager();
            ConsoleSender consoleSender = commandManager.getConsoleSender();
            if (line.wordIndex() == 0) {
                String commandString = line.word().toLowerCase();
                candidates.addAll(commandManager.getDispatcher().getCommands().stream().map(Command::getName).filter(name2 -> commandString.isBlank() || name2.toLowerCase().startsWith(commandString)).map(Candidate::new).toList());
            } else {
                String text = line.line();
                Suggestion suggestion = TabCompleteListener.getSuggestion(consoleSender, text);
                if (suggestion != null) {
                    suggestion.getEntries().stream().map(SuggestionEntry::getEntry).map(Candidate::new).forEach(candidates::add);
                }
            }
        }
    }
}

