/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.tag;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.RecordComponent;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.minestom.server.item.ItemStack;
import net.minestom.server.tag.Serializers;
import net.minestom.server.tag.Tag;
import net.minestom.server.tag.TagReadable;
import net.minestom.server.tag.TagSerializer;
import net.minestom.server.tag.TagWritable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;

final class TagRecord {
    static final Map<Class<?>, Function<String, Tag<?>>> SUPPORTED_TYPES = Map.ofEntries(Map.entry(Byte.class, Tag::Byte), Map.entry(Byte.TYPE, Tag::Byte), Map.entry(Boolean.class, Tag::Boolean), Map.entry(Boolean.TYPE, Tag::Boolean), Map.entry(Short.class, Tag::Short), Map.entry(Short.TYPE, Tag::Short), Map.entry(Integer.class, Tag::Integer), Map.entry(Integer.TYPE, Tag::Integer), Map.entry(Long.class, Tag::Long), Map.entry(Long.TYPE, Tag::Long), Map.entry(Float.class, Tag::Float), Map.entry(Float.TYPE, Tag::Float), Map.entry(Double.class, Tag::Double), Map.entry(Double.TYPE, Tag::Double), Map.entry(String.class, Tag::String), Map.entry(UUID.class, Tag::UUID), Map.entry(ItemStack.class, Tag::ItemStack), Map.entry(Component.class, Tag::Component));
    static final ClassValue<Serializer<? extends Record>> serializers = new ClassValue<Serializer<? extends Record>>(){

        @Override
        protected Serializer<? extends Record> computeValue(Class<?> type2) {
            Constructor<?> constructor;
            assert (type2.isRecord());
            RecordComponent[] components = type2.getRecordComponents();
            Entry[] entries2 = (Entry[])Arrays.stream(components).map(recordComponent -> {
                Tag<Object> tag;
                String componentName = recordComponent.getName();
                Class<?> componentType = recordComponent.getType();
                if (componentType.isRecord()) {
                    tag = Tag.Structure(componentName, serializers.get(componentType));
                } else if (NBT.class.isAssignableFrom(componentType)) {
                    tag = Tag.NBT(componentName);
                } else {
                    Function<String, Tag<?>> fun = SUPPORTED_TYPES.get(componentType);
                    if (fun == null) {
                        throw new IllegalArgumentException("Unsupported type: " + componentType);
                    }
                    tag = fun.apply(componentName);
                }
                return new Entry((RecordComponent)recordComponent, tag);
            }).toArray(Entry[]::new);
            try {
                constructor = type2.getDeclaredConstructor((Class[])Arrays.stream(components).map(RecordComponent::getType).toArray(Class[]::new));
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            return new Serializer((Constructor)Constructor.class.cast(constructor), entries2);
        }
    };

    TagRecord() {
    }

    @NotNull
    static <T extends Record> Serializer<T> serializer(@NotNull Class<T> type2) {
        assert (type2.isRecord());
        return serializers.get(type2);
    }

    static final class Serializer<T extends Record>
    implements TagSerializer<T> {
        final Constructor<T> constructor;
        final Entry[] entries;
        final Serializers.Entry<T, NBTCompound> serializerEntry;

        Serializer(Constructor<T> constructor, Entry[] entries2) {
            this.constructor = constructor;
            this.entries = entries2;
            this.serializerEntry = Serializers.fromTagSerializer(this);
        }

        @Override
        @Nullable
        public T read(@NotNull TagReadable reader) {
            Object[] components = new Object[this.entries.length];
            for (int i = 0; i < components.length; ++i) {
                Entry entry2 = this.entries[i];
                Object component = reader.getTag(entry2.tag);
                if (component == null) {
                    return null;
                }
                components[i] = component;
            }
            try {
                return (T)((Record)this.constructor.newInstance(components));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void write(@NotNull TagWritable writer, @NotNull T value) {
            try {
                for (Entry entry2 : this.entries) {
                    Object component = entry2.component.getAccessor().invoke(value, new Object[0]);
                    writer.setTag(entry2.tag, component);
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    record Entry(RecordComponent component, Tag<Object> tag) {
    }
}

