/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.tag;

import java.lang.invoke.VarHandle;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minestom.server.tag.Serializers;
import net.minestom.server.tag.StaticIntMap;
import net.minestom.server.tag.Tag;
import net.minestom.server.tag.TagHandler;
import net.minestom.server.tag.TagNbtSeparator;
import net.minestom.server.tag.TagReadable;
import net.minestom.server.utils.PropertyUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.NBTCompoundLike;
import org.jglrxavpok.hephaistos.nbt.NBTType;
import org.jglrxavpok.hephaistos.nbt.mutable.MutableNBTCompound;

final class TagHandlerImpl
implements TagHandler {
    private static final boolean CACHE_ENABLE = PropertyUtils.getBoolean("minestom.tag-handler-cache", true);
    static final Serializers.Entry<Node, NBTCompound> NODE_SERIALIZER = new Serializers.Entry<Node, NBTCompound>(NBTType.TAG_Compound, entries2 -> TagHandlerImpl.fromCompound((NBTCompoundLike)entries2).root, Node::compound, true);
    private final Node root;
    private volatile Node copy;

    TagHandlerImpl(Node root) {
        this.root = root;
    }

    TagHandlerImpl() {
        this.root = new Node();
    }

    static TagHandlerImpl fromCompound(NBTCompoundLike compoundLike) {
        NBTCompound compound = compoundLike.toCompound();
        TagHandlerImpl handler = new TagHandlerImpl();
        TagNbtSeparator.separate(compound, entry2 -> handler.setTag(entry2.tag(), entry2.value()));
        handler.root.compound = compound;
        return handler;
    }

    @Override
    public <T> @UnknownNullability T getTag(@NotNull Tag<T> tag) {
        VarHandle.fullFence();
        return this.root.getTag(tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void setTag(@NotNull Tag<T> tag, @Nullable T value) {
        if (tag.isView()) {
            TagHandlerImpl tagHandlerImpl = this;
            synchronized (tagHandlerImpl) {
                Node syncNode = this.traversePathWrite(this.root, tag, value != null);
                if (syncNode != null) {
                    syncNode.updateContent(value != null ? (NBTCompound)tag.entry.write(value) : NBTCompound.EMPTY);
                    syncNode.invalidate();
                }
            }
            return;
        }
        int tagIndex = tag.index;
        VarHandle.fullFence();
        Node node = this.traversePathWrite(this.root, tag, value != null);
        if (node == null) {
            return;
        }
        StaticIntMap<Entry<?>> entries2 = node.entries;
        if (value != null) {
            Entry<?> previous = entries2.get(tagIndex);
            if (previous != null && previous.tag.shareValue(tag)) {
                previous.updateValue(tag.copyValue(value));
            } else {
                TagHandlerImpl tagHandlerImpl = this;
                synchronized (tagHandlerImpl) {
                    node = this.traversePathWrite(this.root, tag, true);
                    node.entries.put(tagIndex, this.valueToEntry(node, tag, value));
                }
            }
        } else {
            TagHandlerImpl tagHandlerImpl = this;
            synchronized (tagHandlerImpl) {
                node = this.traversePathWrite(this.root, tag, false);
                if (node == null) {
                    return;
                }
                node.entries.remove(tagIndex);
            }
        }
        node.invalidate();
    }

    @Override
    public <T> void updateTag(@NotNull Tag<T> tag, @NotNull UnaryOperator<@UnknownNullability T> value) {
        this.updateTag0(tag, value, false);
    }

    @Override
    public <T> @UnknownNullability T updateAndGetTag(@NotNull Tag<T> tag, @NotNull UnaryOperator<@UnknownNullability T> value) {
        return this.updateTag0(tag, value, false);
    }

    @Override
    public <T> @UnknownNullability T getAndUpdateTag(@NotNull Tag<T> tag, @NotNull UnaryOperator<@UnknownNullability T> value) {
        return this.updateTag0(tag, value, true);
    }

    private synchronized <T> T updateTag0(@NotNull Tag<T> tag, @NotNull UnaryOperator<T> value, boolean returnPrevious) {
        T previousValue;
        Node node = this.traversePathWrite(this.root, tag, true);
        if (tag.isView()) {
            T previousValue2 = tag.read(node.compound());
            Object newValue = value.apply(previousValue2);
            node.updateContent((NBTCompoundLike)((Object)tag.entry.write(newValue)));
            node.invalidate();
            return (T)(returnPrevious ? previousValue2 : newValue);
        }
        StaticIntMap<Entry<?>> entries2 = node.entries;
        int tagIndex = tag.index;
        Entry<?> previousEntry = entries2.get(tagIndex);
        if (previousEntry != null) {
            Object previousTmp = previousEntry.value;
            if (previousTmp instanceof Node) {
                Node n = (Node)previousTmp;
                NBTCompound compound = NBT.Compound(Map.of(tag.getKey(), n.compound()));
                previousValue = tag.read(compound);
            } else {
                previousValue = previousTmp;
            }
        } else {
            previousValue = tag.createDefault();
        }
        Object newValue = value.apply(previousValue);
        if (newValue != null) {
            entries2.put(tagIndex, this.valueToEntry(node, tag, newValue));
        } else {
            entries2.remove(tagIndex);
        }
        node.invalidate();
        return (T)(returnPrevious ? previousValue : newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public TagReadable readableCopy() {
        Node copy2 = this.copy;
        if (copy2 == null) {
            TagHandlerImpl tagHandlerImpl = this;
            synchronized (tagHandlerImpl) {
                this.copy = copy2 = this.root.copy(null);
            }
        }
        return copy2;
    }

    @Override
    @NotNull
    public synchronized TagHandler copy() {
        return new TagHandlerImpl(this.root.copy(null));
    }

    @Override
    public synchronized void updateContent(@NotNull NBTCompoundLike compound) {
        this.root.updateContent(compound);
    }

    @Override
    @NotNull
    public NBTCompound asCompound() {
        VarHandle.fullFence();
        return this.root.compound();
    }

    private static Node traversePathRead(Node node, Tag<?> tag) {
        Tag.PathEntry[] paths = tag.path;
        if (paths == null) {
            return node;
        }
        for (Tag.PathEntry path : paths) {
            Entry<?> entry2 = node.entries.get(path.index());
            if (entry2 != null && (node = entry2.toNode()) != null) continue;
            return null;
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="_, _, true -> !null")
    private Node traversePathWrite(Node root, Tag<?> tag, boolean present) {
        Tag.PathEntry[] paths = tag.path;
        if (paths == null) {
            return root;
        }
        Node local = root;
        for (Tag.PathEntry path : paths) {
            int pathIndex = path.index();
            Entry<?> entry2 = local.entries.get(pathIndex);
            if (entry2 != null && entry2.tag.entry.isPath()) {
                Node tmp = (Node)entry2.value;
                assert (tmp.parent == local) : "Path parent is invalid: " + tmp.parent + " != " + local;
                local = tmp;
                continue;
            }
            if (!present) {
                return null;
            }
            TagHandlerImpl tagHandlerImpl = this;
            synchronized (tagHandlerImpl) {
                NBT nBT;
                Node tmp;
                Entry<?> synEntry = local.entries.get(pathIndex);
                if (synEntry != null && synEntry.tag.entry.isPath()) {
                    tmp = (Node)synEntry.value;
                    assert (tmp.parent == local) : "Path parent is invalid: " + tmp.parent + " != " + local;
                    local = tmp;
                    continue;
                }
                tmp = local;
                local = new Node(tmp);
                if (synEntry != null && (nBT = synEntry.updatedNbt()) instanceof NBTCompound) {
                    NBTCompound compound = (NBTCompound)nBT;
                    local.updateContent(compound);
                }
                tmp.entries.put(pathIndex, Entry.makePathEntry(path.name(), local));
            }
        }
        return local;
    }

    private <T> Entry<?> valueToEntry(Node parent, Tag<T> tag, @NotNull T value) {
        if (value instanceof NBT) {
            NBT nbt = (NBT)value;
            if (nbt instanceof NBTCompound) {
                NBTCompound compound = (NBTCompound)nbt;
                TagHandlerImpl handler = TagHandlerImpl.fromCompound(compound);
                return Entry.makePathEntry(tag, new Node(parent, handler.root.entries));
            }
            TagNbtSeparator.Entry nbtEntry = TagNbtSeparator.separateSingle(tag.getKey(), nbt);
            return new Entry(nbtEntry.tag(), nbtEntry.value());
        }
        return new Entry<T>(tag, tag.copyValue(value));
    }

    final class Node
    implements TagReadable {
        final Node parent;
        final StaticIntMap<Entry<?>> entries;
        NBTCompound compound;

        public Node(Node parent, StaticIntMap<Entry<?>> entries2) {
            this.parent = parent;
            this.entries = entries2;
        }

        Node(Node parent) {
            this(parent, new StaticIntMap.Array());
        }

        Node() {
            this(null);
        }

        @Override
        public <T> @UnknownNullability T getTag(@NotNull Tag<T> tag) {
            Node node = TagHandlerImpl.traversePathRead(this, tag);
            if (node == null) {
                return tag.createDefault();
            }
            if (tag.isView()) {
                return tag.read(node.compound());
            }
            StaticIntMap<Entry<?>> entries2 = node.entries;
            Entry<?> entry2 = entries2.get(tag.index);
            if (entry2 == null) {
                return tag.createDefault();
            }
            if (entry2.tag.shareValue(tag)) {
                return entry2.value;
            }
            NBT nbt = entry2.updatedNbt();
            Serializers.Entry serializerEntry = tag.entry;
            NBTType<NBT> type2 = serializerEntry.nbtType();
            return type2 == null || type2 == nbt.getID() ? serializerEntry.read(nbt) : tag.createDefault();
        }

        void updateContent(@NotNull NBTCompoundLike compoundLike) {
            NBTCompound compound = compoundLike.toCompound();
            TagHandlerImpl converted = TagHandlerImpl.fromCompound(compound);
            this.entries.updateContent(converted.root.entries);
            this.compound = compound;
        }

        NBTCompound compound() {
            NBTCompound compound;
            if (!CACHE_ENABLE || (compound = this.compound) == null) {
                MutableNBTCompound tmp = new MutableNBTCompound();
                this.entries.forValues(entry2 -> {
                    Tag tag = entry2.tag;
                    NBT nbt = entry2.updatedNbt();
                    if (!tag.entry.isPath() || !((NBTCompound)nbt).isEmpty()) {
                        tmp.put(tag.getKey(), nbt);
                    }
                });
                this.compound = compound = tmp.toCompound();
            }
            return compound;
        }

        @Contract(value="null -> !null")
        Node copy(Node parent) {
            MutableNBTCompound tmp = new MutableNBTCompound();
            Node result2 = new Node(parent, new StaticIntMap.Array());
            StaticIntMap<Entry<?>> entries2 = result2.entries;
            this.entries.forValues(entry2 -> {
                NBT nbt;
                Tag tag = entry2.tag;
                Object value = entry2.value;
                if (value instanceof Node) {
                    Node node = (Node)value;
                    Node copy2 = node.copy(result2);
                    if (copy2 == null) {
                        return;
                    }
                    value = copy2;
                    nbt = copy2.compound;
                    assert (nbt != null) : "Node copy should also compute the compound";
                } else {
                    nbt = entry2.updatedNbt();
                }
                tmp.put(tag.getKey(), nbt);
                entries2.put(tag.index, TagHandlerImpl.this.valueToEntry(result2, tag, value));
            });
            if (tmp.isEmpty() && parent != null) {
                return null;
            }
            result2.compound = tmp.toCompound();
            return result2;
        }

        void invalidate() {
            Node tmp = this;
            do {
                tmp.compound = null;
            } while ((tmp = tmp.parent) != null);
            TagHandlerImpl.this.copy = null;
        }
    }

    private static final class Entry<T> {
        private final Tag<T> tag;
        T value;
        NBT nbt;

        Entry(Tag<T> tag, T value) {
            this.tag = tag;
            this.value = value;
        }

        static Entry<?> makePathEntry(String path, Node node) {
            return new Entry<Node>(Tag.tag(path, NODE_SERIALIZER), node);
        }

        static Entry<?> makePathEntry(Tag<?> tag, Node node) {
            return Entry.makePathEntry(tag.getKey(), node);
        }

        NBT updatedNbt() {
            if (this.tag.entry.isPath()) {
                return ((Node)this.value).compound();
            }
            NBT nbt = this.nbt;
            if (nbt == null) {
                this.nbt = nbt = this.tag.entry.write(this.value);
            }
            return nbt;
        }

        void updateValue(T value) {
            assert (!this.tag.entry.isPath());
            this.value = value;
            this.nbt = null;
        }

        Node toNode() {
            if (this.tag.entry.isPath()) {
                return (Node)this.value;
            }
            NBT nBT = this.updatedNbt();
            if (nBT instanceof NBTCompound) {
                NBTCompound compound = (NBTCompound)nBT;
                return TagHandlerImpl.fromCompound((NBTCompoundLike)compound).root;
            }
            return null;
        }
    }
}

