/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.tag;

import java.util.UUID;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minestom.server.item.ItemStack;
import net.minestom.server.tag.TagHandler;
import net.minestom.server.tag.TagSerializer;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTByte;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.NBTDouble;
import org.jglrxavpok.hephaistos.nbt.NBTFloat;
import org.jglrxavpok.hephaistos.nbt.NBTInt;
import org.jglrxavpok.hephaistos.nbt.NBTIntArray;
import org.jglrxavpok.hephaistos.nbt.NBTLong;
import org.jglrxavpok.hephaistos.nbt.NBTShort;
import org.jglrxavpok.hephaistos.nbt.NBTString;
import org.jglrxavpok.hephaistos.nbt.NBTType;

final class Serializers {
    static final Entry<Byte, NBTByte> BYTE = new Entry<Byte, NBTByte>(NBTType.TAG_Byte, NBTByte::getValue, NBT::Byte);
    static final Entry<Boolean, NBTByte> BOOLEAN = new Entry<Boolean, NBTByte>(NBTType.TAG_Byte, NBTByte::asBoolean, NBT::Boolean);
    static final Entry<Short, NBTShort> SHORT = new Entry<Short, NBTShort>(NBTType.TAG_Short, NBTShort::getValue, NBT::Short);
    static final Entry<Integer, NBTInt> INT = new Entry<Integer, NBTInt>(NBTType.TAG_Int, NBTInt::getValue, NBT::Int);
    static final Entry<Long, NBTLong> LONG = new Entry<Long, NBTLong>(NBTType.TAG_Long, NBTLong::getValue, NBT::Long);
    static final Entry<Float, NBTFloat> FLOAT = new Entry<Float, NBTFloat>(NBTType.TAG_Float, NBTFloat::getValue, NBT::Float);
    static final Entry<Double, NBTDouble> DOUBLE = new Entry<Double, NBTDouble>(NBTType.TAG_Double, NBTDouble::getValue, NBT::Double);
    static final Entry<String, NBTString> STRING = new Entry<String, NBTString>(NBTType.TAG_String, NBTString::getValue, NBT::String);
    static final Entry<NBT, NBT> NBT_ENTRY = new Entry(null, Function.identity(), Function.identity());
    static final Entry<UUID, NBTIntArray> UUID = new Entry<UUID, NBTIntArray>(NBTType.TAG_Int_Array, intArray -> Serializers.intArrayToUuid(intArray.getValue().copyArray()), uuid -> NBT.IntArray(Serializers.uuidToIntArray(uuid)));
    static final Entry<ItemStack, NBTCompound> ITEM = new Entry<ItemStack, NBTCompound>(NBTType.TAG_Compound, ItemStack::fromItemNBT, ItemStack::toItemNBT);
    static final Entry<Component, NBTString> COMPONENT = new Entry<Component, NBTString>(NBTType.TAG_String, input -> GsonComponentSerializer.gson().deserialize(input.getValue()), component -> NBT.String((String)GsonComponentSerializer.gson().serialize(component)));

    Serializers() {
    }

    static <T> Entry<T, NBTCompound> fromTagSerializer(TagSerializer<T> serializer) {
        return new Entry<Object, NBTCompound>(NBTType.TAG_Compound, compound -> {
            if (compound.isEmpty()) {
                return null;
            }
            return serializer.read(TagHandler.fromCompound(compound));
        }, value -> {
            if (value == null) {
                return NBTCompound.EMPTY;
            }
            TagHandler handler = TagHandler.newHandler();
            serializer.write(handler, value);
            return handler.asCompound();
        });
    }

    private static int[] uuidToIntArray(UUID uuid) {
        int[] array = new int[4];
        long uuidMost = uuid.getMostSignificantBits();
        long uuidLeast = uuid.getLeastSignificantBits();
        array[0] = (int)(uuidMost >> 32);
        array[1] = (int)uuidMost;
        array[2] = (int)(uuidLeast >> 32);
        array[3] = (int)uuidLeast;
        return array;
    }

    private static UUID intArrayToUuid(int[] array) {
        long uuidMost = (long)array[0] << 32 | (long)array[1] & 0xFFFFFFFFL;
        long uuidLeast = (long)array[2] << 32 | (long)array[3] & 0xFFFFFFFFL;
        return new UUID(uuidMost, uuidLeast);
    }

    record Entry<T, N extends NBT>(NBTType<N> nbtType, Function<N, T> reader, Function<T, N> writer, boolean isPath) {
        Entry(NBTType<N> nbtType, Function<N, T> reader, Function<T, N> writer) {
            this(nbtType, reader, writer, false);
        }

        T read(N nbt) {
            return this.reader.apply(nbt);
        }

        N write(T value) {
            return (N)((NBT)this.writer.apply(value));
        }
    }
}

