/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.snapshot;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import net.minestom.server.snapshot.Snapshot;
import net.minestom.server.snapshot.SnapshotUpdater;
import net.minestom.server.snapshot.Snapshotable;
import org.jetbrains.annotations.NotNull;

final class SnapshotUpdaterImpl
implements SnapshotUpdater {
    private final IdentityHashMap<Snapshotable, AtomicReference<Snapshot>> referenceMap = new IdentityHashMap();
    private IdentityHashMap<Snapshotable, AtomicReference<Snapshot>> readOnlyReferenceMap;
    private List<Entry> queue = new ArrayList<Entry>();

    SnapshotUpdaterImpl() {
    }

    @NotNull
    static <T extends Snapshot> T update(@NotNull Snapshotable snapshotable) {
        SnapshotUpdaterImpl updater = new SnapshotUpdaterImpl();
        AtomicReference<T> ref = updater.reference(snapshotable);
        updater.update();
        return (T)((Snapshot)ref.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <T extends Snapshot> AtomicReference<T> reference(@NotNull Snapshotable snapshotable) {
        AtomicReference<Snapshot> ref;
        IdentityHashMap<Snapshotable, AtomicReference<Snapshot>> readOnly = this.readOnlyReferenceMap;
        if (readOnly != null && (ref = readOnly.get(snapshotable)) != null) {
            return ref;
        }
        SnapshotUpdaterImpl snapshotUpdaterImpl = this;
        synchronized (snapshotUpdaterImpl) {
            ref = new AtomicReference();
            AtomicReference<Snapshot> prev = this.referenceMap.putIfAbsent(snapshotable, ref);
            if (prev != null) {
                return prev;
            }
            this.queue.add(new Entry(snapshotable, ref));
            return ref;
        }
    }

    void update() {
        ArrayList<Entry> temp;
        while (!(temp = new ArrayList<Entry>(this.queue)).isEmpty()) {
            this.queue = new ArrayList<Entry>();
            this.readOnlyReferenceMap = (IdentityHashMap)this.referenceMap.clone();
            temp.parallelStream().forEach(entry2 -> {
                Snapshotable snap = entry2.snapshotable;
                entry2.ref.set(Objects.requireNonNull(snap.updateSnapshot(this), "Snapshot must not be null after an update!"));
            });
        }
    }

    record Entry(Snapshotable snapshotable, AtomicReference<Snapshot> ref) {
    }
}

