/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.scoreboard;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.minestom.server.scoreboard.Team;
import net.minestom.server.scoreboard.TeamBuilder;
import net.minestom.server.utils.PacketUtils;
import net.minestom.server.utils.UniqueIdUtils;
import org.jetbrains.annotations.NotNull;

public final class TeamManager {
    private final Set<Team> teams = new CopyOnWriteArraySet<Team>();

    protected void registerNewTeam(@NotNull Team team) {
        this.teams.add(team);
        PacketUtils.broadcastPacket(team.createTeamsCreationPacket());
    }

    public boolean deleteTeam(@NotNull String registryName) {
        Team team = this.getTeam(registryName);
        if (team == null) {
            return false;
        }
        return this.deleteTeam(team);
    }

    public boolean deleteTeam(@NotNull Team team) {
        PacketUtils.broadcastPacket(team.createTeamDestructionPacket());
        return this.teams.remove(team);
    }

    public TeamBuilder createBuilder(@NotNull String name2) {
        return new TeamBuilder(name2, this);
    }

    public Team createTeam(@NotNull String name2) {
        return this.createBuilder(name2).build();
    }

    public Team createTeam(String name2, Component prefix, NamedTextColor teamColor, Component suffix) {
        return this.createBuilder(name2).prefix(prefix).teamColor(teamColor).suffix(suffix).updateTeamPacket().build();
    }

    public Team createTeam(String name2, Component displayName, Component prefix, NamedTextColor teamColor, Component suffix) {
        return this.createBuilder(name2).teamDisplayName(displayName).prefix(prefix).teamColor(teamColor).suffix(suffix).updateTeamPacket().build();
    }

    public Team getTeam(String teamName) {
        for (Team team : this.teams) {
            if (!team.getTeamName().equals(teamName)) continue;
            return team;
        }
        return null;
    }

    public boolean exists(String teamName) {
        for (Team team : this.teams) {
            if (!team.getTeamName().equals(teamName)) continue;
            return true;
        }
        return false;
    }

    public boolean exists(Team team) {
        return this.exists(team.getTeamName());
    }

    public List<String> getPlayers(Team team) {
        ArrayList<String> players = new ArrayList<String>();
        for (String member : team.getMembers()) {
            boolean match = UniqueIdUtils.isUniqueId(member);
            if (match) continue;
            players.add(member);
        }
        return players;
    }

    public List<String> getEntities(Team team) {
        ArrayList<String> entities = new ArrayList<String>();
        for (String member : team.getMembers()) {
            boolean match = UniqueIdUtils.isUniqueId(member);
            if (!match) continue;
            entities.add(member);
        }
        return entities;
    }

    public Set<Team> getTeams() {
        return this.teams;
    }
}

