/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.scoreboard;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.kyori.adventure.text.Component;
import net.minestom.server.entity.Player;
import net.minestom.server.network.packet.server.play.ScoreboardObjectivePacket;
import net.minestom.server.scoreboard.Scoreboard;
import org.jetbrains.annotations.NotNull;

public class BelowNameTag
implements Scoreboard {
    public static final String BELOW_NAME_TAG_PREFIX = "bnt-";
    private final Set<Player> viewers = new CopyOnWriteArraySet<Player>();
    private final Set<Player> unmodifiableViewers = Collections.unmodifiableSet(this.viewers);
    private final String objectiveName;
    private final ScoreboardObjectivePacket scoreboardObjectivePacket;

    @Deprecated
    public BelowNameTag(String name2, String value) {
        this(name2, Component.text(value));
    }

    public BelowNameTag(String name2, Component value) {
        this.objectiveName = BELOW_NAME_TAG_PREFIX + name2;
        this.scoreboardObjectivePacket = this.getCreationObjectivePacket(value, ScoreboardObjectivePacket.Type.INTEGER);
    }

    @Override
    @NotNull
    public String getObjectiveName() {
        return this.objectiveName;
    }

    @Override
    public boolean addViewer(@NotNull Player player) {
        boolean result2 = this.viewers.add(player);
        if (result2) {
            player.sendPacket(this.scoreboardObjectivePacket);
            player.sendPacket(this.getDisplayScoreboardPacket((byte)2));
            player.setBelowNameTag(this);
        }
        return result2;
    }

    @Override
    public boolean removeViewer(@NotNull Player player) {
        boolean result2 = this.viewers.remove(player);
        if (result2) {
            player.sendPacket(this.getDestructionObjectivePacket());
            player.setBelowNameTag(null);
        }
        return result2;
    }

    @Override
    @NotNull
    public Set<Player> getViewers() {
        return this.unmodifiableViewers;
    }
}

