/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.registry;

import com.google.gson.ToNumberPolicy;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minestom.server.MinecraftServer;
import net.minestom.server.collision.BoundingBox;
import net.minestom.server.collision.CollisionUtils;
import net.minestom.server.collision.Shape;
import net.minestom.server.entity.EntitySpawnType;
import net.minestom.server.entity.EquipmentSlot;
import net.minestom.server.instance.block.Block;
import net.minestom.server.item.Material;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.collection.ObjectArray;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Registry {
    @ApiStatus.Internal
    public static BlockEntry block(String namespace, @NotNull Properties main) {
        return new BlockEntry(namespace, main, null);
    }

    @ApiStatus.Internal
    public static MaterialEntry material(String namespace, @NotNull Properties main) {
        return new MaterialEntry(namespace, main, null);
    }

    @ApiStatus.Internal
    public static EntityEntry entity(String namespace, @NotNull Properties main) {
        return new EntityEntry(namespace, main, null);
    }

    @ApiStatus.Internal
    public static EnchantmentEntry enchantment(String namespace, @NotNull Properties main) {
        return new EnchantmentEntry(namespace, main, null);
    }

    @ApiStatus.Internal
    public static PotionEffectEntry potionEffect(String namespace, @NotNull Properties main) {
        return new PotionEffectEntry(namespace, main, null);
    }

    @ApiStatus.Internal
    public static Map<String, Map<String, Object>> load(Resource resource) {
        HashMap<String, Map<String, Object>> map2 = new HashMap<String, Map<String, Object>>();
        try (InputStream resourceStream = Registry.class.getClassLoader().getResourceAsStream(resource.name);){
            Check.notNull(resourceStream, "Resource {0} does not exist!", new Object[]{resource});
            try (JsonReader reader = new JsonReader(new InputStreamReader(resourceStream));){
                reader.beginObject();
                while (reader.hasNext()) {
                    map2.put(reader.nextName(), (Map)Registry.readObject(reader));
                }
                reader.endObject();
            }
        }
        catch (IOException e) {
            MinecraftServer.getExceptionManager().handleException(e);
        }
        return map2;
    }

    @ApiStatus.Internal
    public static <T extends ProtocolObject> Container<T> createContainer(Resource resource, Container.Loader<T> loader) {
        Map<String, Map<String, Object>> entries2 = Registry.load(resource);
        HashMap<String, T> namespaces = new HashMap<String, T>(entries2.size());
        ObjectArray<T> ids = ObjectArray.singleThread(entries2.size());
        for (Map.Entry<String, Map<String, Object>> entry2 : entries2.entrySet()) {
            String namespace = entry2.getKey();
            Properties properties2 = Properties.fromMap(entry2.getValue());
            T value = loader.get(namespace, properties2);
            ids.set(value.id(), value);
            namespaces.put(value.name(), value);
        }
        return new Container(resource, namespaces, ids);
    }

    private static Object readObject(JsonReader reader) throws IOException {
        return switch (reader.peek()) {
            case JsonToken.BEGIN_ARRAY -> {
                ArrayList<Object> list = new ArrayList<Object>();
                reader.beginArray();
                while (reader.hasNext()) {
                    list.add(Registry.readObject(reader));
                }
                reader.endArray();
                yield list;
            }
            case JsonToken.BEGIN_OBJECT -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                reader.beginObject();
                while (reader.hasNext()) {
                    map.put(reader.nextName(), Registry.readObject(reader));
                }
                reader.endObject();
                yield map;
            }
            case JsonToken.STRING -> reader.nextString();
            case JsonToken.NUMBER -> ToNumberPolicy.LONG_OR_DOUBLE.readNumber(reader);
            case JsonToken.BOOLEAN -> reader.nextBoolean();
            default -> throw new IllegalStateException("Invalid peek: " + reader.peek());
        };
    }

    public static final class BlockEntry
    implements Entry {
        private final NamespaceID namespace;
        private final int id;
        private final int stateId;
        private final String translationKey;
        private final double hardness;
        private final double explosionResistance;
        private final double friction;
        private final double speedFactor;
        private final double jumpFactor;
        private final boolean air;
        private final boolean solid;
        private final boolean liquid;
        private final String blockEntity;
        private final int blockEntityId;
        private final Supplier<Material> materialSupplier;
        private final Shape shape;
        private final Properties custom;

        private BlockEntry(String namespace, Properties main, Properties custom) {
            this.custom = custom;
            this.namespace = NamespaceID.from(namespace);
            this.id = main.getInt("id");
            this.stateId = main.getInt("stateId");
            this.translationKey = main.getString("translationKey");
            this.hardness = main.getDouble("hardness");
            this.explosionResistance = main.getDouble("explosionResistance");
            this.friction = main.getDouble("friction");
            this.speedFactor = main.getDouble("speedFactor", 1.0);
            this.jumpFactor = main.getDouble("jumpFactor", 1.0);
            this.air = main.getBoolean("air", false);
            this.solid = main.getBoolean("solid");
            this.liquid = main.getBoolean("liquid", false);
            Properties blockEntity = main.section("blockEntity");
            if (blockEntity != null) {
                this.blockEntity = blockEntity.getString("namespace");
                this.blockEntityId = blockEntity.getInt("id");
            } else {
                this.blockEntity = null;
                this.blockEntityId = 0;
            }
            String materialNamespace = main.getString("correspondingItem", null);
            this.materialSupplier = materialNamespace != null ? () -> Material.fromNamespaceId(materialNamespace) : () -> null;
            String string = main.getString("collisionShape");
            this.shape = CollisionUtils.parseBlockShape(string, this);
        }

        @NotNull
        public NamespaceID namespace() {
            return this.namespace;
        }

        public int id() {
            return this.id;
        }

        public int stateId() {
            return this.stateId;
        }

        public String translationKey() {
            return this.translationKey;
        }

        public double hardness() {
            return this.hardness;
        }

        public double explosionResistance() {
            return this.explosionResistance;
        }

        public double friction() {
            return this.friction;
        }

        public double speedFactor() {
            return this.speedFactor;
        }

        public double jumpFactor() {
            return this.jumpFactor;
        }

        public boolean isAir() {
            return this.air;
        }

        public boolean isSolid() {
            return this.solid;
        }

        public boolean isLiquid() {
            return this.liquid;
        }

        public boolean isBlockEntity() {
            return this.blockEntity != null;
        }

        @Nullable
        public String blockEntity() {
            return this.blockEntity;
        }

        public int blockEntityId() {
            return this.blockEntityId;
        }

        @Nullable
        public Material material() {
            return this.materialSupplier.get();
        }

        public Shape collisionShape() {
            return this.shape;
        }

        @Override
        public Properties custom() {
            return this.custom;
        }
    }

    public static interface Properties
    extends Iterable<Map.Entry<String, Object>> {
        public static Properties fromMap(Map<String, Object> map2) {
            return new PropertiesMap(map2);
        }

        public String getString(String var1, String var2);

        public String getString(String var1);

        public double getDouble(String var1, double var2);

        public double getDouble(String var1);

        public int getInt(String var1, int var2);

        public int getInt(String var1);

        public boolean getBoolean(String var1, boolean var2);

        public boolean getBoolean(String var1);

        public Properties section(String var1);

        public Map<String, Object> asMap();

        @Override
        @NotNull
        default public Iterator<Map.Entry<String, Object>> iterator() {
            return this.asMap().entrySet().iterator();
        }

        default public int size() {
            return this.asMap().size();
        }
    }

    public static final class MaterialEntry
    implements Entry {
        private final NamespaceID namespace;
        private final int id;
        private final String translationKey;
        private final int maxStackSize;
        private final int maxDamage;
        private final boolean isFood;
        private final Supplier<Block> blockSupplier;
        private final EquipmentSlot equipmentSlot;
        private final Properties custom;

        private MaterialEntry(String namespace, Properties main, Properties custom) {
            this.custom = custom;
            this.namespace = NamespaceID.from(namespace);
            this.id = main.getInt("id");
            this.translationKey = main.getString("translationKey");
            this.maxStackSize = main.getInt("maxStackSize", 64);
            this.maxDamage = main.getInt("maxDamage", 0);
            this.isFood = main.getBoolean("edible", false);
            String blockNamespace = main.getString("correspondingBlock", null);
            this.blockSupplier = blockNamespace != null ? () -> Block.fromNamespaceId(blockNamespace) : () -> null;
            Properties armorProperties = main.section("armorProperties");
            if (armorProperties != null) {
                switch (armorProperties.getString("slot")) {
                    case "feet": {
                        this.equipmentSlot = EquipmentSlot.BOOTS;
                        break;
                    }
                    case "legs": {
                        this.equipmentSlot = EquipmentSlot.LEGGINGS;
                        break;
                    }
                    case "chest": {
                        this.equipmentSlot = EquipmentSlot.CHESTPLATE;
                        break;
                    }
                    case "head": {
                        this.equipmentSlot = EquipmentSlot.HELMET;
                        break;
                    }
                    default: {
                        this.equipmentSlot = null;
                        break;
                    }
                }
            } else {
                this.equipmentSlot = null;
            }
        }

        @NotNull
        public NamespaceID namespace() {
            return this.namespace;
        }

        public int id() {
            return this.id;
        }

        public String translationKey() {
            return this.translationKey;
        }

        public int maxStackSize() {
            return this.maxStackSize;
        }

        public int maxDamage() {
            return this.maxDamage;
        }

        public boolean isFood() {
            return this.isFood;
        }

        @Nullable
        public Block block() {
            return this.blockSupplier.get();
        }

        public boolean isArmor() {
            return this.equipmentSlot != null;
        }

        @Nullable
        public EquipmentSlot equipmentSlot() {
            return this.equipmentSlot;
        }

        @Override
        public Properties custom() {
            return this.custom;
        }
    }

    public record EntityEntry(NamespaceID namespace, int id, String translationKey, double width, double height, double drag, double acceleration, EntitySpawnType spawnType, BoundingBox boundingBox, Properties custom) implements Entry
    {
        public EntityEntry(String namespace, Properties main, Properties custom) {
            this(NamespaceID.from(namespace), main.getInt("id"), main.getString("translationKey"), main.getDouble("width"), main.getDouble("height"), main.getDouble("drag", 0.02), main.getDouble("acceleration", 0.08), EntitySpawnType.valueOf(main.getString("packetType").toUpperCase(Locale.ROOT)), new BoundingBox(main.getDouble("width"), main.getDouble("height"), main.getDouble("width")), custom);
        }
    }

    public record EnchantmentEntry(NamespaceID namespace, int id, String translationKey, double maxLevel, boolean isCursed, boolean isDiscoverable, boolean isTradeable, boolean isTreasureOnly, Properties custom) implements Entry
    {
        public EnchantmentEntry(String namespace, Properties main, Properties custom) {
            this(NamespaceID.from(namespace), main.getInt("id"), main.getString("translationKey"), main.getDouble("maxLevel"), main.getBoolean("isCursed", false), main.getBoolean("isDiscoverable", true), main.getBoolean("isTradeable", true), main.getBoolean("isTreasureOnly", false), custom);
        }
    }

    public record PotionEffectEntry(NamespaceID namespace, int id, String translationKey, int color, boolean isInstantaneous, Properties custom) implements Entry
    {
        public PotionEffectEntry(String namespace, Properties main, Properties custom) {
            this(NamespaceID.from(namespace), main.getInt("id"), main.getString("translationKey"), main.getInt("color"), main.getBoolean("instantaneous"), custom);
        }
    }

    @ApiStatus.Internal
    public static enum Resource {
        BLOCKS("blocks.json"),
        ITEMS("items.json"),
        ENTITIES("entities.json"),
        ENCHANTMENTS("enchantments.json"),
        SOUNDS("sounds.json"),
        COMMAND_ARGUMENTS("command_arguments.json"),
        STATISTICS("custom_statistics.json"),
        POTION_EFFECTS("potion_effects.json"),
        POTION_TYPES("potions.json"),
        PARTICLES("particles.json"),
        BLOCK_TAGS("tags/block_tags.json"),
        ENTITY_TYPE_TAGS("tags/entity_type_tags.json"),
        FLUID_TAGS("tags/fluid_tags.json"),
        GAMEPLAY_TAGS("tags/gameplay_tags.json"),
        ITEM_TAGS("tags/item_tags.json");

        private final String name;

        private Resource(String name2) {
            this.name = name2;
        }
    }

    @ApiStatus.Internal
    public record Container<T extends ProtocolObject>(Resource resource, Map<String, T> namespaces, ObjectArray<T> ids) {
        public Container {
            namespaces = Map.copyOf(namespaces);
            ids.trim();
        }

        public T get(@NotNull String namespace) {
            return (T)((ProtocolObject)this.namespaces.get(namespace));
        }

        public T getSafe(@NotNull String namespace) {
            return this.get((String)(namespace.contains(":") ? namespace : "minecraft:" + namespace));
        }

        public T getId(int id2) {
            return (T)((ProtocolObject)this.ids.get(id2));
        }

        public int toId(@NotNull String namespace) {
            return this.get(namespace).id();
        }

        public Collection<T> values() {
            return this.namespaces.values();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Container)) {
                return false;
            }
            Container container = (Container)o;
            return this.resource == container.resource;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{this.resource});
        }

        public static interface Loader<T extends ProtocolObject> {
            public T get(String var1, Properties var2);
        }
    }

    record PropertiesMap(Map<String, Object> map) implements Properties
    {
        @Override
        public String getString(String name2, String defaultValue) {
            Object element = this.element(name2);
            return element != null ? (String)element : defaultValue;
        }

        @Override
        public String getString(String name2) {
            return (String)this.element(name2);
        }

        @Override
        public double getDouble(String name2, double defaultValue) {
            Object element = this.element(name2);
            return element != null ? ((Number)element).doubleValue() : defaultValue;
        }

        @Override
        public double getDouble(String name2) {
            return ((Number)this.element(name2)).doubleValue();
        }

        @Override
        public int getInt(String name2, int defaultValue) {
            Object element = this.element(name2);
            return element != null ? ((Number)element).intValue() : defaultValue;
        }

        @Override
        public int getInt(String name2) {
            return ((Number)this.element(name2)).intValue();
        }

        @Override
        public boolean getBoolean(String name2, boolean defaultValue) {
            Object element = this.element(name2);
            return element != null ? (Boolean)element : defaultValue;
        }

        @Override
        public boolean getBoolean(String name2) {
            return (Boolean)this.element(name2);
        }

        @Override
        public Properties section(String name2) {
            Map map2 = (Map)this.element(name2);
            if (map2 == null) {
                return null;
            }
            return new PropertiesMap(map2);
        }

        @Override
        public Map<String, Object> asMap() {
            return this.map;
        }

        private <T> T element(String name2) {
            return (T)this.map.get(name2);
        }
    }

    public static interface Entry {
        @ApiStatus.Experimental
        public Properties custom();
    }
}

