/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.recipe;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.packet.server.play.DeclareRecipesPacket;
import net.minestom.server.recipe.Recipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ShapedRecipe
extends Recipe {
    private final int width;
    private final int height;
    private String group;
    private final List<DeclareRecipesPacket.Ingredient> ingredients;
    private ItemStack result;

    protected ShapedRecipe(@NotNull String recipeId, int width, int height, @NotNull String group, @Nullable List<DeclareRecipesPacket.Ingredient> ingredients, @NotNull ItemStack result2) {
        super(Recipe.Type.SHAPED, recipeId);
        this.width = width;
        this.height = height;
        this.group = group;
        this.ingredients = Objects.requireNonNullElseGet(ingredients, LinkedList::new);
        this.result = result2;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @NotNull
    public String getGroup() {
        return this.group;
    }

    public void setGroup(@NotNull String group) {
        this.group = group;
    }

    public void addIngredient(DeclareRecipesPacket.Ingredient ingredient) {
        if (this.ingredients.size() + 1 > this.width * this.height) {
            throw new IndexOutOfBoundsException("You cannot add more ingredients than width*height");
        }
        this.ingredients.add(ingredient);
    }

    @NotNull
    public List<DeclareRecipesPacket.Ingredient> getIngredients() {
        return this.ingredients;
    }

    @NotNull
    public ItemStack getResult() {
        return this.result;
    }

    public void setResult(@NotNull ItemStack result2) {
        this.result = result2;
    }
}

