/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.ping;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.function.Function;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minestom.server.MinecraftServer;
import net.minestom.server.ping.ResponseData;
import net.minestom.server.utils.identity.NamedAndIdentified;
import org.jetbrains.annotations.NotNull;

public enum ServerListPingType {
    MODERN_FULL_RGB(data2 -> ServerListPingType.getModernPingResponse(data2, true).toString()),
    MODERN_NAMED_COLORS(data2 -> ServerListPingType.getModernPingResponse(data2, false).toString()),
    LEGACY_VERSIONED(data2 -> ServerListPingType.getLegacyPingResponse(data2, true)),
    LEGACY_UNVERSIONED(data2 -> ServerListPingType.getLegacyPingResponse(data2, false)),
    OPEN_TO_LAN(ServerListPingType::getOpenToLANPing);

    private final Function<ResponseData, String> pingResponseCreator;
    private static final String LAN_PING_FORMAT = "[MOTD]%s[/MOTD][AD]%s[/AD]";
    private static final GsonComponentSerializer FULL_RGB;
    private static final GsonComponentSerializer NAMED_RGB;
    private static final LegacyComponentSerializer SECTION;

    private ServerListPingType(Function<ResponseData, String> pingResponseCreator) {
        this.pingResponseCreator = pingResponseCreator;
    }

    @NotNull
    public String getPingResponse(@NotNull ResponseData responseData) {
        return this.pingResponseCreator.apply(responseData);
    }

    @NotNull
    public static String getOpenToLANPing(@NotNull ResponseData data2) {
        return String.format(LAN_PING_FORMAT, SECTION.serialize(data2.getDescription()), MinecraftServer.getServer().getPort());
    }

    @NotNull
    public static String getLegacyPingResponse(@NotNull ResponseData data2, boolean supportsVersions) {
        String motd = SECTION.serialize(data2.getDescription());
        if (supportsVersions) {
            return String.format("\u00a71\u0000%d\u0000%s\u0000%s\u0000%d\u0000%d", data2.getProtocol(), data2.getVersion(), motd, data2.getOnline(), data2.getMaxPlayer());
        }
        return String.format("%s\u00a7%d\u00a7%d", motd, data2.getOnline(), data2.getMaxPlayer());
    }

    @NotNull
    public static JsonObject getModernPingResponse(@NotNull ResponseData data2, boolean supportsFullRgb) {
        JsonObject versionObject = new JsonObject();
        versionObject.addProperty("name", data2.getVersion());
        versionObject.addProperty("protocol", data2.getProtocol());
        JsonObject playersObject = null;
        if (!data2.arePlayersHidden()) {
            playersObject = new JsonObject();
            playersObject.addProperty("max", data2.getMaxPlayer());
            playersObject.addProperty("online", data2.getOnline());
            JsonArray sampleArray = new JsonArray();
            for (NamedAndIdentified entry2 : data2.getEntries()) {
                JsonObject playerObject = new JsonObject();
                playerObject.addProperty("name", SECTION.serialize(entry2.getName()));
                playerObject.addProperty("id", entry2.getUuid().toString());
                sampleArray.add(playerObject);
            }
            playersObject.add("sample", sampleArray);
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("version", versionObject);
        jsonObject.add("players", playersObject);
        jsonObject.addProperty("favicon", data2.getFavicon());
        if (supportsFullRgb) {
            jsonObject.add("description", FULL_RGB.serializeToTree(data2.getDescription()));
        } else {
            jsonObject.add("description", NAMED_RGB.serializeToTree(data2.getDescription()));
        }
        return jsonObject;
    }

    @NotNull
    public static ServerListPingType fromModernProtocolVersion(int version2) {
        if (version2 >= 713) {
            return MODERN_FULL_RGB;
        }
        return MODERN_NAMED_COLORS;
    }

    static {
        FULL_RGB = GsonComponentSerializer.gson();
        NAMED_RGB = GsonComponentSerializer.colorDownsamplingGson();
        SECTION = LegacyComponentSerializer.legacySection();
    }
}

