/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.permission;

import java.util.Set;
import net.minestom.server.permission.Permission;
import net.minestom.server.permission.PermissionVerifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PermissionHandler {
    @NotNull
    public Set<Permission> getAllPermissions();

    default public void addPermission(@NotNull Permission permission) {
        this.getAllPermissions().add(permission);
    }

    default public void removePermission(@NotNull Permission permission) {
        this.getAllPermissions().remove(permission);
    }

    default public void removePermission(@NotNull String permissionName) {
        this.getAllPermissions().removeIf(permission -> permission.getPermissionName().equals(permissionName));
    }

    default public boolean hasPermission(@NotNull Permission permission) {
        for (Permission permissionLoop : this.getAllPermissions()) {
            if (!permissionLoop.equals(permission)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    default public Permission getPermission(@NotNull String permissionName) {
        for (Permission permission : this.getAllPermissions()) {
            if (!permission.getPermissionName().equals(permissionName)) continue;
            return permission;
        }
        return null;
    }

    default public boolean hasPermission(@NotNull String permissionName, @Nullable PermissionVerifier permissionVerifier) {
        Permission permission = this.getPermission(permissionName);
        if (permission != null) {
            return permissionVerifier == null || permissionVerifier.isValid(permission.getNBTData());
        }
        return false;
    }

    default public boolean hasPermission(@NotNull String permissionName) {
        return this.hasPermission(permissionName, null);
    }
}

