/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play.data;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minestom.server.coordinate.Point;
import net.minestom.server.instance.block.Block;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.Registry;
import net.minestom.server.utils.block.BlockUtils;
import net.minestom.server.utils.chunk.ChunkUtils;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;

public record ChunkData(@NotNull NBTCompound heightmaps, byte @NotNull [] data, @NotNull Map<Integer, Block> blockEntities) implements NetworkBuffer.Writer
{
    public ChunkData(@NotNull NBTCompound heightmaps, byte[] data2, @NotNull Map<Integer, Block> blockEntities) {
        blockEntities = blockEntities.entrySet().stream().filter(entry2 -> ((Block)entry2.getValue()).registry().isBlockEntity()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public ChunkData(@NotNull NetworkBuffer reader) {
        this((NBTCompound)reader.read(NetworkBuffer.NBT), reader.read(NetworkBuffer.BYTE_ARRAY), ChunkData.readBlockEntities(reader));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.NBT, this.heightmaps);
        writer.write(NetworkBuffer.BYTE_ARRAY, this.data);
        writer.write(NetworkBuffer.VAR_INT, this.blockEntities.size());
        for (Map.Entry<Integer, Block> entry2 : this.blockEntities.entrySet()) {
            int index = entry2.getKey();
            Block block = entry2.getValue();
            Registry.BlockEntry registry = block.registry();
            Point point = ChunkUtils.getBlockPosition(index, 0, 0);
            writer.write(NetworkBuffer.BYTE, (byte)((point.blockX() & 0xF) << 4 | point.blockZ() & 0xF));
            writer.write(NetworkBuffer.SHORT, (short)point.blockY());
            writer.write(NetworkBuffer.VAR_INT, registry.blockEntityId());
            NBTCompound nbt = BlockUtils.extractClientNbt(block);
            assert (nbt != null);
            writer.write(NetworkBuffer.NBT, nbt);
        }
    }

    private static Map<Integer, Block> readBlockEntities(@NotNull NetworkBuffer reader) {
        HashMap<Integer, Block> blockEntities = new HashMap<Integer, Block>();
        int size = reader.read(NetworkBuffer.VAR_INT);
        for (int i = 0; i < size; ++i) {
            byte xz = reader.read(NetworkBuffer.BYTE);
            short y = reader.read(NetworkBuffer.SHORT);
            int blockEntityId = reader.read(NetworkBuffer.VAR_INT);
            NBTCompound nBTCompound = (NBTCompound)reader.read(NetworkBuffer.NBT);
        }
        return blockEntities;
    }
}

