/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import org.jetbrains.annotations.NotNull;

public record UpdateScorePacket(@NotNull String entityName, byte action, @NotNull String objectiveName, int value) implements ServerPacket
{
    public UpdateScorePacket(@NotNull NetworkBuffer reader) {
        this(UpdateScorePacket.read(reader));
    }

    private UpdateScorePacket(UpdateScorePacket packet) {
        this(packet.entityName, packet.action, packet.objectiveName, packet.value);
    }

    private static UpdateScorePacket read(@NotNull NetworkBuffer reader) {
        String entityName = reader.read(NetworkBuffer.STRING);
        Byte action = reader.read(NetworkBuffer.BYTE);
        String objectiveName = reader.read(NetworkBuffer.STRING);
        int value = action != 1 ? reader.read(NetworkBuffer.VAR_INT) : 0;
        return new UpdateScorePacket(entityName, action, objectiveName, value);
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.STRING, this.entityName);
        writer.write(NetworkBuffer.BYTE, this.action);
        writer.write(NetworkBuffer.STRING, this.objectiveName);
        if (this.action != 1) {
            writer.write(NetworkBuffer.VAR_INT, this.value);
        }
    }

    @Override
    public int getId() {
        return ServerPacketIdentifier.UPDATE_SCORE;
    }
}

