/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.List;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

public record UnlockRecipesPacket(int mode, boolean craftingRecipeBookOpen, boolean craftingRecipeBookFilterActive, boolean smeltingRecipeBookOpen, boolean smeltingRecipeBookFilterActive, boolean blastFurnaceRecipeBookOpen, boolean blastFurnaceRecipeBookFilterActive, boolean smokerRecipeBookOpen, boolean smokerRecipeBookFilterActive, @NotNull List<String> recipeIds, @UnknownNullability List<String> initRecipeIds) implements ServerPacket
{
    public UnlockRecipesPacket(int mode, boolean craftingRecipeBookOpen, boolean craftingRecipeBookFilterActive, boolean smeltingRecipeBookOpen, boolean smeltingRecipeBookFilterActive, boolean blastFurnaceRecipeBookOpen, boolean blastFurnaceRecipeBookFilterActive, boolean smokerRecipeBookOpen, boolean smokerRecipeBookFilterActive, @NotNull List<String> recipeIds, @UnknownNullability List<String> initRecipeIds) {
        recipeIds = List.copyOf(recipeIds);
        if (initRecipeIds != null) {
            initRecipeIds = List.copyOf(initRecipeIds);
        }
    }

    public UnlockRecipesPacket(@NotNull NetworkBuffer reader) {
        this(UnlockRecipesPacket.read(reader));
    }

    private UnlockRecipesPacket(UnlockRecipesPacket packet) {
        this(packet.mode, packet.craftingRecipeBookOpen, packet.craftingRecipeBookFilterActive, packet.smeltingRecipeBookOpen, packet.smeltingRecipeBookFilterActive, packet.blastFurnaceRecipeBookOpen, packet.blastFurnaceRecipeBookFilterActive, packet.smokerRecipeBookOpen, packet.smokerRecipeBookFilterActive, packet.recipeIds, packet.initRecipeIds);
    }

    private static UnlockRecipesPacket read(@NotNull NetworkBuffer reader) {
        Integer mode = reader.read(NetworkBuffer.VAR_INT);
        Boolean craftingRecipeBookOpen = reader.read(NetworkBuffer.BOOLEAN);
        Boolean craftingRecipeBookFilterActive = reader.read(NetworkBuffer.BOOLEAN);
        Boolean smeltingRecipeBookOpen = reader.read(NetworkBuffer.BOOLEAN);
        Boolean smeltingRecipeBookFilterActive = reader.read(NetworkBuffer.BOOLEAN);
        Boolean blastFurnaceRecipeBookOpen = reader.read(NetworkBuffer.BOOLEAN);
        Boolean blastFurnaceRecipeBookFilterActive = reader.read(NetworkBuffer.BOOLEAN);
        Boolean smokerRecipeBookOpen = reader.read(NetworkBuffer.BOOLEAN);
        Boolean smokerRecipeBookFilterActive = reader.read(NetworkBuffer.BOOLEAN);
        List<String> recipeIds = reader.readCollection(NetworkBuffer.STRING);
        List<String> initRecipeIds = mode == 0 ? reader.readCollection(NetworkBuffer.STRING) : null;
        return new UnlockRecipesPacket(mode, craftingRecipeBookOpen, craftingRecipeBookFilterActive, smeltingRecipeBookOpen, smeltingRecipeBookFilterActive, blastFurnaceRecipeBookOpen, blastFurnaceRecipeBookFilterActive, smokerRecipeBookOpen, smokerRecipeBookFilterActive, recipeIds, initRecipeIds);
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.VAR_INT, this.mode);
        writer.write(NetworkBuffer.BOOLEAN, this.craftingRecipeBookOpen);
        writer.write(NetworkBuffer.BOOLEAN, this.craftingRecipeBookFilterActive);
        writer.write(NetworkBuffer.BOOLEAN, this.smeltingRecipeBookOpen);
        writer.write(NetworkBuffer.BOOLEAN, this.smeltingRecipeBookFilterActive);
        writer.write(NetworkBuffer.BOOLEAN, this.blastFurnaceRecipeBookOpen);
        writer.write(NetworkBuffer.BOOLEAN, this.blastFurnaceRecipeBookFilterActive);
        writer.write(NetworkBuffer.BOOLEAN, this.smokerRecipeBookOpen);
        writer.write(NetworkBuffer.BOOLEAN, this.smokerRecipeBookFilterActive);
        writer.writeCollection(NetworkBuffer.STRING, this.recipeIds);
        if (this.mode == 0) {
            writer.writeCollection(NetworkBuffer.STRING, this.initRecipeIds);
        }
    }

    @Override
    public int getId() {
        return ServerPacketIdentifier.UNLOCK_RECIPES;
    }
}

