/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.UUID;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import org.jetbrains.annotations.NotNull;

public record SpawnPlayerPacket(int entityId, @NotNull UUID playerUuid, @NotNull Pos position) implements ServerPacket
{
    public SpawnPlayerPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.UUID), new Pos(reader.read(NetworkBuffer.DOUBLE), reader.read(NetworkBuffer.DOUBLE), reader.read(NetworkBuffer.DOUBLE), (float)reader.read(NetworkBuffer.BYTE).byteValue() * 360.0f / 256.0f, (float)reader.read(NetworkBuffer.BYTE).byteValue() * 360.0f / 256.0f));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.VAR_INT, this.entityId);
        writer.write(NetworkBuffer.UUID, this.playerUuid);
        writer.write(NetworkBuffer.DOUBLE, this.position.x());
        writer.write(NetworkBuffer.DOUBLE, this.position.y());
        writer.write(NetworkBuffer.DOUBLE, this.position.z());
        writer.write(NetworkBuffer.BYTE, (byte)(this.position.yaw() * 256.0f / 360.0f));
        writer.write(NetworkBuffer.BYTE, (byte)(this.position.pitch() * 256.0f / 360.0f));
    }

    @Override
    public int getId() {
        return ServerPacketIdentifier.SPAWN_PLAYER;
    }
}

