/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.kyori.adventure.sound.Sound;
import net.minestom.server.adventure.AdventurePacketConvertor;
import net.minestom.server.coordinate.Point;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.sound.SoundEvent;
import org.jetbrains.annotations.NotNull;

public record SoundEffectPacket(int soundId, @NotNull Sound.Source source, int x, int y, int z, float volume, float pitch, long seed) implements ServerPacket
{
    public SoundEffectPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.VAR_INT), reader.readEnum(Sound.Source.class), reader.read(NetworkBuffer.INT) * 8, reader.read(NetworkBuffer.INT) * 8, reader.read(NetworkBuffer.INT) * 8, reader.read(NetworkBuffer.FLOAT).floatValue(), reader.read(NetworkBuffer.FLOAT).floatValue(), reader.read(NetworkBuffer.LONG));
    }

    public SoundEffectPacket(@NotNull SoundEvent sound, @NotNull Sound.Source source, @NotNull Point position, float volume, float pitch) {
        this(sound.id(), source, (int)position.x(), (int)position.y(), (int)position.z(), volume, pitch, 0L);
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.VAR_INT, this.soundId);
        writer.write(NetworkBuffer.VAR_INT, AdventurePacketConvertor.getSoundSourceValue(this.source));
        writer.write(NetworkBuffer.INT, this.x * 8);
        writer.write(NetworkBuffer.INT, this.y * 8);
        writer.write(NetworkBuffer.INT, this.z * 8);
        writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.volume));
        writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.pitch));
        writer.write(NetworkBuffer.LONG, this.seed);
    }

    @Override
    public int getId() {
        return ServerPacketIdentifier.SOUND_EFFECT;
    }
}

