/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import net.kyori.adventure.text.Component;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ComponentHoldingServerPacket;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.resourcepack.ResourcePack;
import org.jetbrains.annotations.NotNull;

public record ResourcePackSendPacket(String url, String hash, boolean forced, Component prompt) implements ComponentHoldingServerPacket
{
    public ResourcePackSendPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.BOOLEAN), reader.read(NetworkBuffer.BOOLEAN) != false ? reader.read(NetworkBuffer.COMPONENT) : null);
    }

    public ResourcePackSendPacket(@NotNull ResourcePack resourcePack) {
        this(resourcePack.getUrl(), resourcePack.getHash(), resourcePack.isForced(), resourcePack.getPrompt());
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.STRING, this.url);
        writer.write(NetworkBuffer.STRING, this.hash);
        writer.write(NetworkBuffer.BOOLEAN, this.forced);
        if (this.prompt != null) {
            writer.write(NetworkBuffer.BOOLEAN, true);
            writer.write(NetworkBuffer.COMPONENT, this.prompt);
        } else {
            writer.write(NetworkBuffer.BOOLEAN, false);
        }
    }

    @Override
    public int getId() {
        return ServerPacketIdentifier.RESOURCE_PACK_SEND;
    }

    @Override
    @NotNull
    public Collection<Component> components() {
        return List.of(this.prompt);
    }

    @Override
    @NotNull
    public ServerPacket copyWithOperator(@NotNull UnaryOperator<Component> operator) {
        return new ResourcePackSendPacket(this.url, this.hash, this.forced, (Component)operator.apply(this.prompt));
    }
}

