/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.UnaryOperator;
import net.kyori.adventure.text.Component;
import net.minestom.server.adventure.ComponentHolder;
import net.minestom.server.crypto.PlayerPublicKey;
import net.minestom.server.entity.GameMode;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ComponentHoldingServerPacket;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PlayerInfoPacket(@NotNull Action action, @NotNull List<Entry> entries) implements ComponentHoldingServerPacket
{
    public PlayerInfoPacket(@NotNull Action action, @NotNull List<Entry> entries2) {
        entries2 = List.copyOf(entries2);
        for (Entry entry2 : entries2) {
            if (entry2.getClass().equals(action.getClazz())) continue;
            throw new IllegalArgumentException("Invalid entry class for action " + action);
        }
    }

    public PlayerInfoPacket(@NotNull Action action, @NotNull Entry entry2) {
        this(action, List.of(entry2));
    }

    public PlayerInfoPacket(@NotNull NetworkBuffer reader) {
        this(PlayerInfoPacket.read(reader));
    }

    private PlayerInfoPacket(PlayerInfoPacket packet) {
        this(packet.action, packet.entries);
    }

    private static PlayerInfoPacket read(@NotNull NetworkBuffer reader) {
        Action action = Action.values()[reader.read(NetworkBuffer.VAR_INT)];
        int playerInfoCount = reader.read(NetworkBuffer.VAR_INT);
        ArrayList<Entry> entries2 = new ArrayList<Entry>(playerInfoCount);
        for (int i = 0; i < playerInfoCount; ++i) {
            UUID uuid = reader.read(NetworkBuffer.UUID);
            entries2.add((Entry)((Object)(switch (action) {
                default -> throw new IncompatibleClassChangeError();
                case Action.ADD_PLAYER -> new AddPlayer(uuid, reader);
                case Action.UPDATE_GAMEMODE -> new UpdateGameMode(uuid, reader);
                case Action.UPDATE_LATENCY -> new UpdateLatency(uuid, reader);
                case Action.UPDATE_DISPLAY_NAME -> new UpdateDisplayName(uuid, reader);
                case Action.REMOVE_PLAYER -> new RemovePlayer(uuid);
            })));
        }
        return new PlayerInfoPacket(action, entries2);
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.VAR_INT, this.action.ordinal());
        writer.writeCollection(this.entries, (w, entry2) -> {
            w.write(NetworkBuffer.UUID, entry2.uuid());
            entry2.write((NetworkBuffer)w);
        });
    }

    @Override
    public int getId() {
        return ServerPacketIdentifier.PLAYER_INFO;
    }

    @Override
    @NotNull
    public Collection<Component> components() {
        switch (this.action) {
            case ADD_PLAYER: 
            case UPDATE_DISPLAY_NAME: {
                ArrayList<Component> components = new ArrayList<Component>();
                for (Entry entry2 : this.entries) {
                    if (!(entry2 instanceof ComponentHolder)) continue;
                    components.addAll(((ComponentHolder)((Object)entry2)).components());
                }
                return components;
            }
        }
        return List.of();
    }

    @Override
    @NotNull
    public ServerPacket copyWithOperator(@NotNull UnaryOperator<Component> operator) {
        return switch (this.action) {
            case Action.ADD_PLAYER, Action.UPDATE_DISPLAY_NAME -> {
                ArrayList<Entry> entries = new ArrayList<Entry>(this.entries.size());
                for (Entry entry : this.entries) {
                    if (entry instanceof ComponentHolder) {
                        entries.add((Entry)((ComponentHolder)((Object)entry)).copyWithOperator(operator));
                        continue;
                    }
                    entries.add(entry);
                }
                yield new PlayerInfoPacket(this.action, entries);
            }
            default -> this;
        };
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Entry
    extends NetworkBuffer.Writer {
        public UUID uuid();
    }

    public static enum Action {
        ADD_PLAYER(AddPlayer.class),
        UPDATE_GAMEMODE(UpdateGameMode.class),
        UPDATE_LATENCY(UpdateLatency.class),
        UPDATE_DISPLAY_NAME(UpdateDisplayName.class),
        REMOVE_PLAYER(RemovePlayer.class);

        private final Class<? extends Entry> clazz;

        private Action(Class<? extends Entry> clazz) {
            this.clazz = clazz;
        }

        @NotNull
        public Class<? extends Entry> getClazz() {
            return this.clazz;
        }
    }

    public record AddPlayer(UUID uuid, String name, List<Property> properties, GameMode gameMode, int ping, @Nullable Component displayName, @Nullable PlayerPublicKey playerPublicKey) implements Entry,
    ComponentHolder<AddPlayer>
    {
        public AddPlayer(UUID uuid, String name2, List<Property> properties2, GameMode gameMode, int ping, @Nullable Component displayName, @Nullable PlayerPublicKey playerPublicKey) {
            properties2 = List.copyOf(properties2);
        }

        public AddPlayer(UUID uuid, NetworkBuffer reader) {
            this(uuid, reader.read(NetworkBuffer.STRING), reader.readCollection(Property::new), GameMode.values()[reader.read(NetworkBuffer.VAR_INT)], reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.BOOLEAN) != false ? reader.read(NetworkBuffer.COMPONENT) : null, reader.read(NetworkBuffer.BOOLEAN) != false ? new PlayerPublicKey(reader) : null);
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.STRING, this.name);
            writer.writeCollection(this.properties);
            writer.write(NetworkBuffer.VAR_INT, Integer.valueOf(this.gameMode.id()));
            writer.write(NetworkBuffer.VAR_INT, this.ping);
            writer.writeOptional(NetworkBuffer.COMPONENT, this.displayName);
            writer.writeOptional(this.playerPublicKey);
        }

        @Override
        @NotNull
        public Collection<Component> components() {
            return this.displayName != null ? List.of(this.displayName) : List.of();
        }

        @Override
        @NotNull
        public AddPlayer copyWithOperator(@NotNull UnaryOperator<Component> operator) {
            return this.displayName != null ? new AddPlayer(this.uuid, this.name, this.properties, this.gameMode, this.ping, (Component)operator.apply(this.displayName), this.playerPublicKey) : this;
        }

        public record Property(@NotNull String name, @NotNull String value, @Nullable String signature) implements NetworkBuffer.Writer
        {
            public Property(String name2, String value) {
                this(name2, value, null);
            }

            public Property(@NotNull NetworkBuffer reader) {
                this(reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.BOOLEAN) != false ? reader.read(NetworkBuffer.STRING) : null);
            }

            @Override
            public void write(@NotNull NetworkBuffer writer) {
                writer.write(NetworkBuffer.STRING, this.name);
                writer.write(NetworkBuffer.STRING, this.value);
                writer.write(NetworkBuffer.BOOLEAN, this.signature != null);
                if (this.signature != null) {
                    writer.write(NetworkBuffer.STRING, this.signature);
                }
            }
        }
    }

    public record UpdateGameMode(UUID uuid, GameMode gameMode) implements Entry
    {
        public UpdateGameMode(UUID uuid, NetworkBuffer reader) {
            this(uuid, GameMode.fromId(reader.read(NetworkBuffer.VAR_INT).byteValue()));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.VAR_INT, Integer.valueOf(this.gameMode.id()));
        }
    }

    public record UpdateLatency(UUID uuid, int ping) implements Entry
    {
        public UpdateLatency(UUID uuid, NetworkBuffer reader) {
            this(uuid, reader.read(NetworkBuffer.VAR_INT));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.VAR_INT, this.ping);
        }
    }

    public record UpdateDisplayName(@NotNull UUID uuid, @Nullable Component displayName) implements Entry,
    ComponentHolder<UpdateDisplayName>
    {
        public UpdateDisplayName(UUID uuid, NetworkBuffer reader) {
            this(uuid, reader.read(NetworkBuffer.BOOLEAN) != false ? reader.read(NetworkBuffer.COMPONENT) : null);
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.BOOLEAN, this.displayName != null);
            if (this.displayName != null) {
                writer.write(NetworkBuffer.COMPONENT, this.displayName);
            }
        }

        @Override
        @NotNull
        public Collection<Component> components() {
            return this.displayName != null ? List.of(this.displayName) : List.of();
        }

        @Override
        @NotNull
        public UpdateDisplayName copyWithOperator(@NotNull UnaryOperator<Component> operator) {
            return this.displayName != null ? new UpdateDisplayName(this.uuid, (Component)operator.apply(this.displayName)) : this;
        }
    }

    public record RemovePlayer(@NotNull UUID uuid) implements Entry
    {
        @Override
        public void write(@NotNull NetworkBuffer writer) {
        }
    }
}

