/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.UnaryOperator;
import net.kyori.adventure.text.Component;
import net.minestom.server.crypto.MessageSignature;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ComponentHoldingServerPacket;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PlayerChatMessagePacket(@NotNull Component signedContent, @Nullable Component unsignedContent, int type, @NotNull UUID uuid, @NotNull Component displayName, @Nullable Component teamDisplayName, @NotNull MessageSignature signature) implements ComponentHoldingServerPacket
{
    public PlayerChatMessagePacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.COMPONENT), reader.readOptional(NetworkBuffer.COMPONENT), reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.UUID), reader.read(NetworkBuffer.COMPONENT), reader.readOptional(NetworkBuffer.COMPONENT), new MessageSignature(reader));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.COMPONENT, this.signedContent);
        writer.writeOptional(NetworkBuffer.COMPONENT, this.unsignedContent);
        writer.write(NetworkBuffer.VAR_INT, this.type);
        writer.write(NetworkBuffer.UUID, this.uuid);
        writer.write(NetworkBuffer.COMPONENT, this.displayName);
        writer.writeOptional(NetworkBuffer.COMPONENT, this.teamDisplayName);
        writer.write(this.signature);
    }

    @Override
    public int getId() {
        return ServerPacketIdentifier.PLAYER_CHAT;
    }

    @Override
    @NotNull
    public Collection<Component> components() {
        return List.of(this.signedContent);
    }

    @Override
    @NotNull
    public ServerPacket copyWithOperator(@NotNull UnaryOperator<Component> operator) {
        return new PlayerChatMessagePacket(this.signedContent, this.unsignedContent, this.type, this.uuid, this.displayName, this.teamDisplayName, this.signature);
    }
}

