/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.kyori.adventure.sound.Sound;
import net.minestom.server.adventure.AdventurePacketConvertor;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import org.jetbrains.annotations.NotNull;

public record NamedSoundEffectPacket(String soundName, Sound.Source source, int x, int y, int z, float volume, float pitch, long seed) implements ServerPacket
{
    public NamedSoundEffectPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.STRING), Sound.Source.values()[reader.read(NetworkBuffer.VAR_INT)], reader.read(NetworkBuffer.INT) / 8, reader.read(NetworkBuffer.INT) / 8, reader.read(NetworkBuffer.INT) / 8, reader.read(NetworkBuffer.FLOAT).floatValue(), reader.read(NetworkBuffer.FLOAT).floatValue(), reader.read(NetworkBuffer.LONG));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.STRING, this.soundName);
        writer.write(NetworkBuffer.VAR_INT, AdventurePacketConvertor.getSoundSourceValue(this.source));
        writer.write(NetworkBuffer.INT, this.x * 8);
        writer.write(NetworkBuffer.INT, this.y * 8);
        writer.write(NetworkBuffer.INT, this.z * 8);
        writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.volume));
        writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.pitch));
        writer.write(NetworkBuffer.LONG, this.seed);
    }

    @Override
    public int getId() {
        return ServerPacketIdentifier.NAMED_SOUND_EFFECT;
    }
}

