/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.List;
import net.minestom.server.entity.GameMode;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;

public record JoinGamePacket(int entityId, boolean isHardcore, GameMode gameMode, GameMode previousGameMode, List<String> worlds, NBTCompound dimensionCodec, String dimensionType, String world, long hashedSeed, int maxPlayers, int viewDistance, int simulationDistance, boolean reducedDebugInfo, boolean enableRespawnScreen, boolean isDebug, boolean isFlat) implements ServerPacket
{
    public JoinGamePacket {
        worlds = List.copyOf(worlds);
    }

    public JoinGamePacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.BOOLEAN), GameMode.fromId(reader.read(NetworkBuffer.BYTE).byteValue()), GameMode.fromId(reader.read(NetworkBuffer.BYTE).byteValue()), reader.readCollection(NetworkBuffer.STRING), (NBTCompound)reader.read(NetworkBuffer.NBT), reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.LONG), reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.BOOLEAN), reader.read(NetworkBuffer.BOOLEAN), reader.read(NetworkBuffer.BOOLEAN), reader.read(NetworkBuffer.BOOLEAN));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.INT, this.entityId);
        writer.write(NetworkBuffer.BOOLEAN, this.isHardcore);
        writer.write(NetworkBuffer.BYTE, this.gameMode.id());
        if (this.previousGameMode != null) {
            writer.write(NetworkBuffer.BYTE, this.previousGameMode.id());
        } else {
            writer.write(NetworkBuffer.BYTE, (byte)-1);
        }
        writer.writeCollection(NetworkBuffer.STRING, this.worlds);
        writer.write(NetworkBuffer.NBT, this.dimensionCodec);
        writer.write(NetworkBuffer.STRING, this.dimensionType);
        writer.write(NetworkBuffer.STRING, this.world);
        writer.write(NetworkBuffer.LONG, this.hashedSeed);
        writer.write(NetworkBuffer.VAR_INT, this.maxPlayers);
        writer.write(NetworkBuffer.VAR_INT, this.viewDistance);
        writer.write(NetworkBuffer.VAR_INT, this.simulationDistance);
        writer.write(NetworkBuffer.BOOLEAN, this.reducedDebugInfo);
        writer.write(NetworkBuffer.BOOLEAN, this.enableRespawnScreen);
        writer.write(NetworkBuffer.BOOLEAN, this.isDebug);
        writer.write(NetworkBuffer.BOOLEAN, this.isFlat);
        writer.write(NetworkBuffer.BOOLEAN, false);
    }

    @Override
    public int getId() {
        return ServerPacketIdentifier.JOIN_GAME;
    }
}

