/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.kyori.adventure.sound.Sound;
import net.minestom.server.adventure.AdventurePacketConvertor;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import org.jetbrains.annotations.NotNull;

public record EntitySoundEffectPacket(int soundId, Sound.Source source, int entityId, float volume, float pitch, long seed) implements ServerPacket
{
    public EntitySoundEffectPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.VAR_INT), Sound.Source.values()[reader.read(NetworkBuffer.VAR_INT)], reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.FLOAT).floatValue(), reader.read(NetworkBuffer.FLOAT).floatValue(), reader.read(NetworkBuffer.LONG));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.VAR_INT, this.soundId);
        writer.write(NetworkBuffer.VAR_INT, AdventurePacketConvertor.getSoundSourceValue(this.source));
        writer.write(NetworkBuffer.VAR_INT, this.entityId);
        writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.volume));
        writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.pitch));
        writer.write(NetworkBuffer.LONG, this.seed);
    }

    @Override
    public int getId() {
        return ServerPacketIdentifier.ENTITY_SOUND_EFFECT;
    }
}

