/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import org.jetbrains.annotations.NotNull;

public record EntityRotationPacket(int entityId, float yaw, float pitch, boolean onGround) implements ServerPacket
{
    public EntityRotationPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.VAR_INT), (float)reader.read(NetworkBuffer.BYTE).byteValue() * 360.0f / 256.0f, (float)reader.read(NetworkBuffer.BYTE).byteValue() * 360.0f / 256.0f, reader.read(NetworkBuffer.BOOLEAN));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.VAR_INT, this.entityId);
        writer.write(NetworkBuffer.BYTE, (byte)(this.yaw * 256.0f / 360.0f));
        writer.write(NetworkBuffer.BYTE, (byte)(this.pitch * 256.0f / 360.0f));
        writer.write(NetworkBuffer.BOOLEAN, this.onGround);
    }

    @Override
    public int getId() {
        return ServerPacketIdentifier.ENTITY_ROTATION;
    }
}

