/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.kyori.adventure.text.Component;
import net.minestom.server.entity.Metadata;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ComponentHoldingServerPacket;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import org.jetbrains.annotations.NotNull;

public record EntityMetaDataPacket(int entityId, @NotNull Map<Integer, Metadata.Entry<?>> entries) implements ComponentHoldingServerPacket
{
    public EntityMetaDataPacket(int entityId2, @NotNull Map<Integer, Metadata.Entry<?>> entries2) {
        entries2 = Map.copyOf(entries2);
    }

    public EntityMetaDataPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.VAR_INT), EntityMetaDataPacket.readEntries(reader));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.VAR_INT, this.entityId);
        for (Map.Entry<Integer, Metadata.Entry<?>> entry2 : this.entries.entrySet()) {
            writer.write(NetworkBuffer.BYTE, entry2.getKey().byteValue());
            writer.write(entry2.getValue());
        }
        writer.write(NetworkBuffer.BYTE, (byte)-1);
    }

    private static Map<Integer, Metadata.Entry<?>> readEntries(@NotNull NetworkBuffer reader) {
        byte index;
        HashMap entries2 = new HashMap();
        while ((index = reader.read(NetworkBuffer.BYTE).byteValue()) != -1) {
            int type2 = reader.read(NetworkBuffer.VAR_INT);
            entries2.put(Integer.valueOf(index), Metadata.Entry.read(type2, reader));
        }
        return entries2;
    }

    @Override
    public int getId() {
        return ServerPacketIdentifier.ENTITY_METADATA;
    }

    @Override
    @NotNull
    public Collection<Component> components() {
        return this.entries.values().stream().map(Metadata.Entry::value).filter(entry2 -> entry2 instanceof Component).map(entry2 -> (Component)entry2).toList();
    }

    @Override
    @NotNull
    public ServerPacket copyWithOperator(@NotNull UnaryOperator<Component> operator) {
        HashMap entries2 = new HashMap();
        this.entries.forEach((key, value) -> {
            Metadata.Entry<Component> entry2;
            Object v = value.value();
            if (v instanceof Component) {
                Component c = (Component)v;
                entry2 = Metadata.OptChat((Component)operator.apply(c));
            } else {
                entry2 = value;
            }
            entries2.put((Integer)key, entry2);
        });
        return new EntityMetaDataPacket(this.entityId, entries2);
    }
}

