/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server;

import net.minestom.server.network.packet.server.CachedPacket;
import net.minestom.server.network.packet.server.FramedPacket;
import net.minestom.server.network.packet.server.LazyPacket;
import net.minestom.server.network.packet.server.ServerPacket;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@ApiStatus.Experimental
public interface SendablePacket {
    @ApiStatus.Experimental
    @NotNull
    public static ServerPacket extractServerPacket(@NotNull SendablePacket packet) {
        if (packet instanceof ServerPacket) {
            ServerPacket serverPacket = (ServerPacket)packet;
            return serverPacket;
        }
        if (packet instanceof CachedPacket) {
            CachedPacket cachedPacket = (CachedPacket)packet;
            return cachedPacket.packet();
        }
        if (packet instanceof FramedPacket) {
            FramedPacket framedPacket = (FramedPacket)packet;
            return framedPacket.packet();
        }
        if (packet instanceof LazyPacket) {
            LazyPacket lazyPacket = (LazyPacket)packet;
            return lazyPacket.packet();
        }
        throw new RuntimeException("Unknown packet type: " + packet.getClass().getName());
    }
}

