/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.client.play;

import java.util.List;
import net.minestom.server.coordinate.Point;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.client.ClientPacket;
import org.jetbrains.annotations.NotNull;

public record ClientUpdateSignPacket(@NotNull Point blockPosition, @NotNull List<String> lines) implements ClientPacket
{
    public ClientUpdateSignPacket(@NotNull Point blockPosition, @NotNull List<String> lines) {
        lines = List.copyOf(lines);
        if (lines.size() != 4) {
            throw new IllegalArgumentException("Signs must have 4 lines!");
        }
        for (String line : lines) {
            if (line.length() <= 384) continue;
            throw new IllegalArgumentException("Signs must have a maximum of 384 characters per line!");
        }
    }

    public ClientUpdateSignPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.BLOCK_POSITION), ClientUpdateSignPacket.readLines(reader));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.BLOCK_POSITION, this.blockPosition);
        writer.write(NetworkBuffer.STRING, this.lines.get(0));
        writer.write(NetworkBuffer.STRING, this.lines.get(1));
        writer.write(NetworkBuffer.STRING, this.lines.get(2));
        writer.write(NetworkBuffer.STRING, this.lines.get(3));
    }

    private static List<String> readLines(@NotNull NetworkBuffer reader) {
        return List.of(reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.STRING));
    }
}

