/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.client.play;

import net.minestom.server.crypto.ArgumentSignatures;
import net.minestom.server.crypto.LastSeenMessages;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.client.ClientPacket;
import org.jetbrains.annotations.NotNull;

public record ClientCommandChatPacket(@NotNull String message, long timestamp, long salt, @NotNull ArgumentSignatures signatures, boolean signedPreview, @NotNull LastSeenMessages.Update lastSeenMessages) implements ClientPacket
{
    public ClientCommandChatPacket(@NotNull String message, long timestamp, long salt, @NotNull ArgumentSignatures signatures, boolean signedPreview, LastSeenMessages.Update lastSeenMessages) {
        if (message.length() > 256) {
            throw new IllegalArgumentException("Message length cannot be greater than 256");
        }
    }

    public ClientCommandChatPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.LONG), reader.read(NetworkBuffer.LONG), new ArgumentSignatures(reader), reader.read(NetworkBuffer.BOOLEAN), new LastSeenMessages.Update(reader));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.STRING, this.message);
        writer.write(NetworkBuffer.LONG, this.timestamp);
        writer.write(NetworkBuffer.LONG, this.salt);
        writer.write(this.signatures);
        writer.write(NetworkBuffer.BOOLEAN, this.signedPreview);
        writer.write(this.lastSeenMessages);
    }
}

