/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.client.play;

import net.minestom.server.crypto.LastSeenMessages;
import net.minestom.server.crypto.MessageSignature;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.client.ClientPacket;
import org.jetbrains.annotations.NotNull;

public record ClientChatMessagePacket(@NotNull String message, long timestamp, long salt, @NotNull MessageSignature signature, boolean signedPreview, @NotNull LastSeenMessages.Update lastSeenMessages) implements ClientPacket
{
    public ClientChatMessagePacket(@NotNull String message, long timestamp, long salt, @NotNull MessageSignature signature2, boolean signedPreview, @NotNull LastSeenMessages.Update lastSeenMessages) {
        if (message.length() > 256) {
            throw new IllegalArgumentException("Message cannot be more than 256 characters long.");
        }
    }

    public ClientChatMessagePacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.LONG), reader.read(NetworkBuffer.LONG), new MessageSignature(reader), reader.read(NetworkBuffer.BOOLEAN), new LastSeenMessages.Update(reader));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.STRING, this.message);
        writer.write(NetworkBuffer.LONG, this.timestamp);
        writer.write(NetworkBuffer.LONG, this.salt);
        writer.write(this.signature);
        writer.write(NetworkBuffer.BOOLEAN, this.signedPreview);
        writer.write(this.lastSeenMessages);
    }
}

