/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.client.login;

import java.time.Instant;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minestom.server.MinecraftServer;
import net.minestom.server.crypto.PlayerPublicKey;
import net.minestom.server.crypto.SignatureValidator;
import net.minestom.server.extras.MojangAuth;
import net.minestom.server.extras.bungee.BungeeCordProxy;
import net.minestom.server.extras.velocity.VelocityProxy;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.client.ClientPreplayPacket;
import net.minestom.server.network.packet.server.login.EncryptionRequestPacket;
import net.minestom.server.network.packet.server.login.LoginDisconnectPacket;
import net.minestom.server.network.packet.server.login.LoginPluginRequestPacket;
import net.minestom.server.network.player.PlayerConnection;
import net.minestom.server.network.player.PlayerSocketConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record LoginStartPacket(@NotNull String username, @Nullable PlayerPublicKey publicKey, @Nullable UUID profileId) implements ClientPreplayPacket
{
    private static final Component ALREADY_CONNECTED = Component.text("You are already on this server", (TextColor)NamedTextColor.RED);

    public LoginStartPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.STRING), reader.readOptional(PlayerPublicKey::new), reader.readOptional(NetworkBuffer.UUID));
    }

    @Override
    public void process(@NotNull PlayerConnection connection) {
        PlayerSocketConnection socketConnection;
        boolean isSocketConnection;
        if (this.publicKey != null) {
            if (!SignatureValidator.YGGDRASIL.validate(binaryWriter -> {
                if (this.profileId != null) {
                    binaryWriter.write(NetworkBuffer.LONG, this.profileId.getMostSignificantBits());
                    binaryWriter.write(NetworkBuffer.LONG, this.profileId.getLeastSignificantBits());
                } else {
                    MinecraftServer.LOGGER.warn("Profile ID was null for player {}, signature will not match!", (Object)this.username);
                }
                binaryWriter.write(NetworkBuffer.LONG, this.publicKey.expiresAt().toEpochMilli());
                binaryWriter.write(NetworkBuffer.RAW_BYTES, this.publicKey.publicKey().getEncoded());
            }, this.publicKey.signature())) {
                connection.sendPacket(new LoginDisconnectPacket(Component.text("Invalid Profile Public Key!")));
                connection.disconnect();
            }
            if (this.publicKey.expiresAt().isBefore(Instant.now())) {
                connection.sendPacket(new LoginDisconnectPacket(Component.text("Expired Profile Public Key!")));
                connection.disconnect();
            }
            connection.setPlayerPublicKey(this.publicKey);
        }
        if (isSocketConnection = connection instanceof PlayerSocketConnection) {
            socketConnection = (PlayerSocketConnection)connection;
            socketConnection.UNSAFE_setLoginUsername(this.username);
            if (VelocityProxy.isEnabled()) {
                int messageId = ThreadLocalRandom.current().nextInt();
                String channel = "velocity:player_info";
                socketConnection.addPluginRequestEntry(messageId, "velocity:player_info");
                connection.sendPacket(new LoginPluginRequestPacket(messageId, "velocity:player_info", null));
                return;
            }
        }
        if (MojangAuth.isEnabled() && isSocketConnection) {
            if (CONNECTION_MANAGER.getPlayer(this.username) != null) {
                connection.sendPacket(new LoginDisconnectPacket(ALREADY_CONNECTED));
                connection.disconnect();
                return;
            }
            socketConnection = (PlayerSocketConnection)connection;
            socketConnection.setConnectionState(ConnectionState.LOGIN);
            byte[] publicKey = MojangAuth.getKeyPair().getPublic().getEncoded();
            byte[] nonce = new byte[4];
            ThreadLocalRandom.current().nextBytes(nonce);
            socketConnection.setNonce(nonce);
            socketConnection.sendPacket(new EncryptionRequestPacket("", publicKey, nonce));
        } else {
            boolean bungee = BungeeCordProxy.isEnabled();
            UUID playerUuid = bungee && isSocketConnection ? ((PlayerSocketConnection)connection).gameProfile().uuid() : CONNECTION_MANAGER.getPlayerConnectionUuid(connection, this.username);
            CONNECTION_MANAGER.startPlayState(connection, playerUuid, this.username, true);
        }
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        if (this.username.length() > 16) {
            throw new IllegalArgumentException("Username is not allowed to be longer than 16 characters");
        }
        writer.write(NetworkBuffer.STRING, this.username);
    }
}

