/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.client.login;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minestom.server.MinecraftServer;
import net.minestom.server.extras.velocity.VelocityProxy;
import net.minestom.server.network.ConnectionManager;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.client.ClientPreplayPacket;
import net.minestom.server.network.packet.server.login.LoginDisconnectPacket;
import net.minestom.server.network.player.GameProfile;
import net.minestom.server.network.player.PlayerConnection;
import net.minestom.server.network.player.PlayerSocketConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record LoginPluginResponsePacket(int messageId, byte @Nullable [] data) implements ClientPreplayPacket
{
    private static final ConnectionManager CONNECTION_MANAGER = MinecraftServer.getConnectionManager();
    public static final Component INVALID_PROXY_RESPONSE = Component.text("Invalid proxy response!", (TextColor)NamedTextColor.RED);

    public LoginPluginResponsePacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.VAR_INT), reader.readOptional(NetworkBuffer.RAW_BYTES));
    }

    @Override
    public void process(@NotNull PlayerConnection connection) {
        PlayerSocketConnection socketConnection;
        String channel;
        if (connection instanceof PlayerSocketConnection && (channel = (socketConnection = (PlayerSocketConnection)connection).getPluginRequestChannel(this.messageId)) != null) {
            NetworkBuffer buffer;
            boolean success = false;
            InetSocketAddress socketAddress = null;
            GameProfile gameProfile = null;
            if (VelocityProxy.isEnabled() && channel.equals("velocity:player_info") && this.data != null && this.data.length > 0 && (success = VelocityProxy.checkIntegrity(buffer = new NetworkBuffer(ByteBuffer.wrap(this.data))))) {
                InetAddress address;
                try {
                    address = InetAddress.getByName(buffer.read(NetworkBuffer.STRING));
                }
                catch (UnknownHostException e) {
                    MinecraftServer.getExceptionManager().handleException(e);
                    return;
                }
                int port = ((InetSocketAddress)connection.getRemoteAddress()).getPort();
                socketAddress = new InetSocketAddress(address, port);
                gameProfile = new GameProfile(buffer);
            }
            if (success) {
                socketConnection.setRemoteAddress(socketAddress);
                socketConnection.UNSAFE_setProfile(gameProfile);
                CONNECTION_MANAGER.startPlayState(connection, gameProfile.uuid(), gameProfile.name(), true);
            } else {
                LoginDisconnectPacket disconnectPacket = new LoginDisconnectPacket(INVALID_PROXY_RESPONSE);
                socketConnection.sendPacket(disconnectPacket);
            }
        }
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.VAR_INT, this.messageId);
        writer.writeOptional(NetworkBuffer.RAW_BYTES, this.data);
    }
}

