/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.client.login;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.math.BigInteger;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.UUID;
import javax.crypto.SecretKey;
import net.minestom.server.MinecraftServer;
import net.minestom.server.crypto.SaltSignaturePair;
import net.minestom.server.crypto.SignatureValidator;
import net.minestom.server.extras.MojangAuth;
import net.minestom.server.extras.mojangAuth.MojangCrypt;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.client.ClientPreplayPacket;
import net.minestom.server.network.player.PlayerConnection;
import net.minestom.server.network.player.PlayerSocketConnection;
import net.minestom.server.utils.Either;
import net.minestom.server.utils.InterfaceUtils;
import net.minestom.server.utils.async.AsyncUtils;
import net.minestom.server.utils.crypto.KeyUtils;
import org.jetbrains.annotations.NotNull;

public record EncryptionResponsePacket(byte[] sharedSecret, Either<byte[], SaltSignaturePair> nonceOrSignature) implements ClientPreplayPacket
{
    private static final Gson GSON = new Gson();

    public EncryptionResponsePacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.BYTE_ARRAY), reader.readEither(networkBuffer -> networkBuffer.read(NetworkBuffer.BYTE_ARRAY), SaltSignaturePair::new));
    }

    @Override
    public void process(@NotNull PlayerConnection connection) {
        if (!(connection instanceof PlayerSocketConnection)) {
            return;
        }
        PlayerSocketConnection socketConnection = (PlayerSocketConnection)connection;
        AsyncUtils.runAsync(() -> {
            String loginUsername = socketConnection.getLoginUsername();
            if (loginUsername == null || loginUsername.isEmpty()) {
                return;
            }
            boolean hasPublicKey = connection.playerPublicKey() != null;
            boolean verificationFailed = this.nonceOrSignature.map(nonce -> hasPublicKey || !Arrays.equals(socketConnection.getNonce(), MojangCrypt.decryptUsingKey(MojangAuth.getKeyPair().getPrivate(), nonce)), signature2 -> !hasPublicKey || !SignatureValidator.from(connection.playerPublicKey().publicKey(), KeyUtils.SignatureAlgorithm.SHA256withRSA).validate(binaryWriter -> {
                binaryWriter.write(NetworkBuffer.RAW_BYTES, socketConnection.getNonce());
                binaryWriter.write(NetworkBuffer.LONG, signature2.salt());
            }, signature2.signature()));
            if (verificationFailed) {
                MinecraftServer.LOGGER.error("Encryption failed for {}", (Object)loginUsername);
                return;
            }
            byte[] digestedData = MojangCrypt.digestData("", MojangAuth.getKeyPair().getPublic(), this.getSecretKey());
            if (digestedData == null) {
                MinecraftServer.LOGGER.error("Connection {} failed initializing encryption.", (Object)socketConnection.getRemoteAddress());
                connection.disconnect();
                return;
            }
            String serverId = new BigInteger(digestedData).toString(16);
            String username = URLEncoder.encode(loginUsername, StandardCharsets.UTF_8);
            String url2 = String.format(MojangAuth.AUTH_URL, username, serverId);
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder(URI.create(url2)).GET().build();
            client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).whenComplete((response, throwable) -> {
                if (throwable != null) {
                    MinecraftServer.getExceptionManager().handleException((Throwable)throwable);
                    return;
                }
                try {
                    JsonObject gameProfile = GSON.fromJson((String)response.body(), JsonObject.class);
                    if (gameProfile == null) {
                        return;
                    }
                    socketConnection.setEncryptionKey(this.getSecretKey());
                    UUID profileUUID = UUID.fromString(gameProfile.get("id").getAsString().replaceFirst("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5"));
                    String profileName = gameProfile.get("name").getAsString();
                    MinecraftServer.LOGGER.info("UUID of player {} is {}", (Object)loginUsername, (Object)profileUUID);
                    CONNECTION_MANAGER.startPlayState(connection, profileUUID, profileName, true);
                }
                catch (Exception e) {
                    MinecraftServer.getExceptionManager().handleException(e);
                }
            });
        });
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.BYTE_ARRAY, this.sharedSecret);
        writer.writeEither(this.nonceOrSignature, (networkBuffer, bytes) -> networkBuffer.write(NetworkBuffer.BYTE_ARRAY, bytes), InterfaceUtils.flipBiConsumer(SaltSignaturePair::write));
    }

    private SecretKey getSecretKey() {
        return MojangCrypt.decryptByteToSecretKey(MojangAuth.getKeyPair().getPrivate(), this.sharedSecret);
    }
}

