/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.client;

import java.util.function.Function;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.client.ClientPacket;
import net.minestom.server.network.packet.client.login.EncryptionResponsePacket;
import net.minestom.server.network.packet.client.login.LoginPluginResponsePacket;
import net.minestom.server.network.packet.client.login.LoginStartPacket;
import net.minestom.server.network.packet.client.play.ClientAdvancementTabPacket;
import net.minestom.server.network.packet.client.play.ClientAnimationPacket;
import net.minestom.server.network.packet.client.play.ClientChatAckPacket;
import net.minestom.server.network.packet.client.play.ClientChatMessagePacket;
import net.minestom.server.network.packet.client.play.ClientChatPreviewPacket;
import net.minestom.server.network.packet.client.play.ClientClickWindowButtonPacket;
import net.minestom.server.network.packet.client.play.ClientClickWindowPacket;
import net.minestom.server.network.packet.client.play.ClientCloseWindowPacket;
import net.minestom.server.network.packet.client.play.ClientCommandChatPacket;
import net.minestom.server.network.packet.client.play.ClientCraftRecipeRequest;
import net.minestom.server.network.packet.client.play.ClientCreativeInventoryActionPacket;
import net.minestom.server.network.packet.client.play.ClientEditBookPacket;
import net.minestom.server.network.packet.client.play.ClientEntityActionPacket;
import net.minestom.server.network.packet.client.play.ClientGenerateStructurePacket;
import net.minestom.server.network.packet.client.play.ClientHeldItemChangePacket;
import net.minestom.server.network.packet.client.play.ClientInteractEntityPacket;
import net.minestom.server.network.packet.client.play.ClientKeepAlivePacket;
import net.minestom.server.network.packet.client.play.ClientNameItemPacket;
import net.minestom.server.network.packet.client.play.ClientPickItemPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerAbilitiesPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerBlockPlacementPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerDiggingPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerPositionAndRotationPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerPositionPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerRotationPacket;
import net.minestom.server.network.packet.client.play.ClientPluginMessagePacket;
import net.minestom.server.network.packet.client.play.ClientPongPacket;
import net.minestom.server.network.packet.client.play.ClientQueryBlockNbtPacket;
import net.minestom.server.network.packet.client.play.ClientQueryEntityNbtPacket;
import net.minestom.server.network.packet.client.play.ClientResourcePackStatusPacket;
import net.minestom.server.network.packet.client.play.ClientSelectTradePacket;
import net.minestom.server.network.packet.client.play.ClientSetBeaconEffectPacket;
import net.minestom.server.network.packet.client.play.ClientSetDisplayedRecipePacket;
import net.minestom.server.network.packet.client.play.ClientSetRecipeBookStatePacket;
import net.minestom.server.network.packet.client.play.ClientSettingsPacket;
import net.minestom.server.network.packet.client.play.ClientSpectatePacket;
import net.minestom.server.network.packet.client.play.ClientStatusPacket;
import net.minestom.server.network.packet.client.play.ClientSteerBoatPacket;
import net.minestom.server.network.packet.client.play.ClientSteerVehiclePacket;
import net.minestom.server.network.packet.client.play.ClientTabCompletePacket;
import net.minestom.server.network.packet.client.play.ClientTeleportConfirmPacket;
import net.minestom.server.network.packet.client.play.ClientUpdateCommandBlockMinecartPacket;
import net.minestom.server.network.packet.client.play.ClientUpdateCommandBlockPacket;
import net.minestom.server.network.packet.client.play.ClientUpdateSignPacket;
import net.minestom.server.network.packet.client.play.ClientUpdateStructureBlockPacket;
import net.minestom.server.network.packet.client.play.ClientUseItemPacket;
import net.minestom.server.network.packet.client.play.ClientVehicleMovePacket;
import net.minestom.server.network.packet.client.status.PingPacket;
import net.minestom.server.network.packet.client.status.StatusRequestPacket;
import net.minestom.server.utils.collection.ObjectArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class ClientPacketsHandler {
    private final ObjectArray<Function<NetworkBuffer, ClientPacket>> suppliers = ObjectArray.singleThread(16);

    private ClientPacketsHandler() {
    }

    public void register(int id2, @NotNull @NotNull Function<@NotNull NetworkBuffer, @NotNull ClientPacket> packetSupplier) {
        this.suppliers.set(id2, packetSupplier);
    }

    public @UnknownNullability ClientPacket create(int packetId, @NotNull NetworkBuffer reader) {
        Function<NetworkBuffer, ClientPacket> supplier = this.suppliers.get(packetId);
        if (supplier == null) {
            throw new IllegalStateException("Packet id 0x" + Integer.toHexString(packetId) + " isn't registered!");
        }
        return supplier.apply(reader);
    }

    public static final class Play
    extends ClientPacketsHandler {
        public Play() {
            this.register(0, ClientTeleportConfirmPacket::new);
            this.register(1, ClientQueryBlockNbtPacket::new);
            this.register(3, ClientChatAckPacket::new);
            this.register(4, ClientCommandChatPacket::new);
            this.register(5, ClientChatMessagePacket::new);
            this.register(6, ClientChatPreviewPacket::new);
            this.register(7, ClientStatusPacket::new);
            this.register(8, ClientSettingsPacket::new);
            this.register(9, ClientTabCompletePacket::new);
            this.register(10, ClientClickWindowButtonPacket::new);
            this.register(11, ClientClickWindowPacket::new);
            this.register(12, ClientCloseWindowPacket::new);
            this.register(13, ClientPluginMessagePacket::new);
            this.register(14, ClientEditBookPacket::new);
            this.register(15, ClientQueryEntityNbtPacket::new);
            this.register(16, ClientInteractEntityPacket::new);
            this.register(17, ClientGenerateStructurePacket::new);
            this.register(18, ClientKeepAlivePacket::new);
            this.register(20, ClientPlayerPositionPacket::new);
            this.register(21, ClientPlayerPositionAndRotationPacket::new);
            this.register(22, ClientPlayerRotationPacket::new);
            this.register(23, ClientPlayerPacket::new);
            this.register(24, ClientVehicleMovePacket::new);
            this.register(25, ClientSteerBoatPacket::new);
            this.register(26, ClientPickItemPacket::new);
            this.register(27, ClientCraftRecipeRequest::new);
            this.register(28, ClientPlayerAbilitiesPacket::new);
            this.register(29, ClientPlayerDiggingPacket::new);
            this.register(30, ClientEntityActionPacket::new);
            this.register(31, ClientSteerVehiclePacket::new);
            this.register(32, ClientPongPacket::new);
            this.register(33, ClientSetRecipeBookStatePacket::new);
            this.register(34, ClientSetDisplayedRecipePacket::new);
            this.register(35, ClientNameItemPacket::new);
            this.register(36, ClientResourcePackStatusPacket::new);
            this.register(37, ClientAdvancementTabPacket::new);
            this.register(38, ClientSelectTradePacket::new);
            this.register(39, ClientSetBeaconEffectPacket::new);
            this.register(40, ClientHeldItemChangePacket::new);
            this.register(41, ClientUpdateCommandBlockPacket::new);
            this.register(42, ClientUpdateCommandBlockMinecartPacket::new);
            this.register(43, ClientCreativeInventoryActionPacket::new);
            this.register(45, ClientUpdateStructureBlockPacket::new);
            this.register(46, ClientUpdateSignPacket::new);
            this.register(47, ClientAnimationPacket::new);
            this.register(48, ClientSpectatePacket::new);
            this.register(49, ClientPlayerBlockPlacementPacket::new);
            this.register(50, ClientUseItemPacket::new);
        }
    }

    public static final class Login
    extends ClientPacketsHandler {
        public Login() {
            this.register(0, LoginStartPacket::new);
            this.register(1, EncryptionResponsePacket::new);
            this.register(2, LoginPluginResponsePacket::new);
        }
    }

    public static final class Status
    extends ClientPacketsHandler {
        public Status() {
            this.register(0, StatusRequestPacket::new);
            this.register(1, PingPacket::new);
        }
    }
}

