/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network;

import java.nio.ByteBuffer;
import net.minestom.server.entity.Player;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.client.ClientPacket;
import net.minestom.server.network.packet.client.ClientPacketsHandler;
import net.minestom.server.network.packet.client.ClientPreplayPacket;
import net.minestom.server.network.packet.client.handshake.HandshakePacket;
import net.minestom.server.network.player.PlayerConnection;
import org.jetbrains.annotations.NotNull;

public record PacketProcessor(@NotNull ClientPacketsHandler statusHandler, @NotNull ClientPacketsHandler loginHandler, @NotNull ClientPacketsHandler playHandler) {
    public PacketProcessor() {
        this(new ClientPacketsHandler.Status(), new ClientPacketsHandler.Login(), new ClientPacketsHandler.Play());
    }

    @NotNull
    public ClientPacket create(@NotNull ConnectionState connectionState, int packetId, ByteBuffer body) {
        NetworkBuffer buffer = new NetworkBuffer(body);
        ClientPacket clientPacket = switch (connectionState) {
            default -> throw new IncompatibleClassChangeError();
            case ConnectionState.PLAY -> this.playHandler.create(packetId, buffer);
            case ConnectionState.LOGIN -> this.loginHandler.create(packetId, buffer);
            case ConnectionState.STATUS -> this.statusHandler.create(packetId, buffer);
            case ConnectionState.UNKNOWN -> {
                if (!$assertionsDisabled && packetId != 0) {
                    throw new AssertionError();
                }
                yield new HandshakePacket(buffer);
            }
        };
        body.position(buffer.readIndex());
        return clientPacket;
    }

    public ClientPacket process(@NotNull PlayerConnection connection, int packetId, ByteBuffer body) {
        ClientPacket packet = this.create(connection.getConnectionState(), packetId, body);
        if (packet instanceof ClientPreplayPacket) {
            ClientPreplayPacket prePlayPacket = (ClientPreplayPacket)packet;
            prePlayPacket.process(connection);
        } else {
            Player player = connection.getPlayer();
            assert (player != null);
            player.addPacketToQueue(packet);
        }
        return packet;
    }
}

