/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minestom.server.MinecraftServer;
import net.minestom.server.entity.Player;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.player.AsyncPlayerPreLoginEvent;
import net.minestom.server.event.player.PlayerLoginEvent;
import net.minestom.server.instance.Instance;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.PlayerProvider;
import net.minestom.server.network.UuidProvider;
import net.minestom.server.network.packet.server.login.LoginSuccessPacket;
import net.minestom.server.network.packet.server.play.KeepAlivePacket;
import net.minestom.server.network.player.PlayerConnection;
import net.minestom.server.network.player.PlayerSocketConnection;
import net.minestom.server.utils.StringUtils;
import net.minestom.server.utils.async.AsyncUtils;
import net.minestom.server.utils.debug.DebugUtils;
import net.minestom.server.utils.validate.Check;
import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.MpscUnboundedArrayQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConnectionManager {
    private static final long KEEP_ALIVE_DELAY = 10000L;
    private static final long KEEP_ALIVE_KICK = 30000L;
    private static final Component TIMEOUT_TEXT = Component.text("Timeout", (TextColor)NamedTextColor.RED);
    private final MessagePassingQueue<Player> waitingPlayers = new MpscUnboundedArrayQueue<Player>(64);
    private final Set<Player> players = new CopyOnWriteArraySet<Player>();
    private final Set<Player> unmodifiablePlayers = Collections.unmodifiableSet(this.players);
    private final Map<PlayerConnection, Player> connectionPlayerMap = new ConcurrentHashMap<PlayerConnection, Player>();
    private volatile UuidProvider uuidProvider = (playerConnection, username) -> UUID.randomUUID();
    private volatile PlayerProvider playerProvider = Player::new;

    public Player getPlayer(@NotNull PlayerConnection connection) {
        return this.connectionPlayerMap.get(connection);
    }

    @NotNull
    public @NotNull Collection<@NotNull Player> getOnlinePlayers() {
        return this.unmodifiablePlayers;
    }

    @Nullable
    public Player findPlayer(@NotNull String username) {
        Player exact = this.getPlayer(username);
        if (exact != null) {
            return exact;
        }
        String username1 = username.toLowerCase(Locale.ROOT);
        Function<Player, Double> distanceFunction = player -> {
            String username2 = player.getUsername().toLowerCase(Locale.ROOT);
            return StringUtils.jaroWinklerScore(username1, username2);
        };
        return this.getOnlinePlayers().stream().min(Comparator.comparingDouble(distanceFunction::apply)).filter(player -> (Double)distanceFunction.apply((Player)player) > 0.0).orElse(null);
    }

    @Nullable
    public Player getPlayer(@NotNull String username) {
        for (Player player : this.getOnlinePlayers()) {
            if (!player.getUsername().equalsIgnoreCase(username)) continue;
            return player;
        }
        return null;
    }

    @Nullable
    public Player getPlayer(@NotNull UUID uuid) {
        for (Player player : this.getOnlinePlayers()) {
            if (!player.getUuid().equals(uuid)) continue;
            return player;
        }
        return null;
    }

    public void setUuidProvider(@Nullable UuidProvider uuidProvider) {
        this.uuidProvider = uuidProvider != null ? uuidProvider : (playerConnection, username) -> UUID.randomUUID();
    }

    @NotNull
    public UUID getPlayerConnectionUuid(@NotNull PlayerConnection playerConnection, @NotNull String username) {
        return this.uuidProvider.provide(playerConnection, username);
    }

    public void setPlayerProvider(@Nullable PlayerProvider playerProvider) {
        this.playerProvider = playerProvider != null ? playerProvider : Player::new;
    }

    @NotNull
    public PlayerProvider getPlayerProvider() {
        return this.playerProvider;
    }

    public synchronized void registerPlayer(@NotNull Player player) {
        this.players.add(player);
        this.connectionPlayerMap.put(player.getPlayerConnection(), player);
    }

    public synchronized void removePlayer(@NotNull PlayerConnection connection) {
        Player player = this.connectionPlayerMap.remove(connection);
        if (player == null) {
            return;
        }
        this.players.remove(player);
    }

    public CompletableFuture<Void> startPlayState(@NotNull Player player, boolean register) {
        return AsyncUtils.runAsync(() -> {
            PlayerConnection playerConnection = player.getPlayerConnection();
            if (playerConnection instanceof PlayerSocketConnection) {
                PlayerSocketConnection socketConnection = (PlayerSocketConnection)playerConnection;
                int threshold = MinecraftServer.getCompressionThreshold();
                if (threshold > 0) {
                    socketConnection.startCompression();
                }
            }
            AsyncPlayerPreLoginEvent asyncPlayerPreLoginEvent = new AsyncPlayerPreLoginEvent(player);
            EventDispatcher.call(asyncPlayerPreLoginEvent);
            if (!player.isOnline()) {
                return;
            }
            String eventUsername = asyncPlayerPreLoginEvent.getUsername();
            UUID eventUuid = asyncPlayerPreLoginEvent.getPlayerUuid();
            if (!player.getUsername().equals(eventUsername)) {
                player.setUsernameField(eventUsername);
            }
            if (!player.getUuid().equals(eventUuid)) {
                player.setUuid(eventUuid);
            }
            LoginSuccessPacket loginSuccessPacket = new LoginSuccessPacket(player.getUuid(), player.getUsername(), 0);
            playerConnection.sendPacket(loginSuccessPacket);
            playerConnection.setConnectionState(ConnectionState.PLAY);
            if (register) {
                this.registerPlayer(player);
            }
            this.waitingPlayers.relaxedOffer(player);
        });
    }

    @NotNull
    public Player startPlayState(@NotNull PlayerConnection connection, @NotNull UUID uuid, @NotNull String username, boolean register) {
        Player player = this.playerProvider.createPlayer(uuid, username, connection);
        this.startPlayState(player, register);
        return player;
    }

    public synchronized void shutdown() {
        this.players.clear();
        this.connectionPlayerMap.clear();
    }

    public void updateWaitingPlayers() {
        this.waitingPlayers.drain(waitingPlayer -> {
            PlayerLoginEvent loginEvent = new PlayerLoginEvent((Player)waitingPlayer);
            EventDispatcher.call(loginEvent);
            Instance spawningInstance = loginEvent.getSpawningInstance();
            Check.notNull(spawningInstance, "You need to specify a spawning instance in the PlayerLoginEvent");
            if (DebugUtils.INSIDE_TEST) {
                waitingPlayer.UNSAFE_init(spawningInstance).join();
            } else {
                waitingPlayer.UNSAFE_init(spawningInstance);
            }
        });
    }

    public void handleKeepAlive(long tickStart) {
        KeepAlivePacket keepAlivePacket = new KeepAlivePacket(tickStart);
        for (Player player : this.getOnlinePlayers()) {
            long lastKeepAlive = tickStart - player.getLastKeepAlive();
            if (lastKeepAlive > 10000L && player.didAnswerKeepAlive()) {
                player.refreshKeepAlive(tickStart);
                player.sendPacket(keepAlivePacket);
                continue;
            }
            if (lastKeepAlive < 30000L) continue;
            player.kick(TIMEOUT_TEXT);
        }
    }
}

