/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.monitoring;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minestom.server.MinecraftServer;
import net.minestom.server.monitoring.ThreadResult;
import net.minestom.server.utils.MathUtils;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BenchmarkManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BenchmarkManager.class);
    private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();
    private static final List<String> THREADS = new ArrayList<String>();
    private final Long2LongMap lastCpuTimeMap = new Long2LongOpenHashMap();
    private final Long2LongMap lastUserTimeMap = new Long2LongOpenHashMap();
    private final Long2LongMap lastWaitedMap = new Long2LongOpenHashMap();
    private final Long2LongMap lastBlockedMap = new Long2LongOpenHashMap();
    private final Map<String, ThreadResult> resultMap = new ConcurrentHashMap<String, ThreadResult>();
    private boolean enabled = false;
    private volatile boolean stop = false;
    private long time;

    public void enable(@NotNull Duration duration) {
        Check.stateCondition(this.enabled, "A benchmark is already running, please disable it first.");
        try {
            THREAD_MX_BEAN.setThreadContentionMonitoringEnabled(true);
            THREAD_MX_BEAN.setThreadCpuTimeEnabled(true);
        }
        catch (Throwable e) {
            LOGGER.warn("Could not enable thread monitoring", e);
            return;
        }
        this.time = duration.toMillis();
        Thread thread2 = new Thread(null, () -> {
            while (!this.stop) {
                this.refreshData();
                try {
                    Thread.sleep(this.time);
                }
                catch (InterruptedException e) {
                    MinecraftServer.getExceptionManager().handleException(e);
                }
            }
            this.stop = false;
        }, "Ms-Benchmark");
        thread2.setDaemon(true);
        thread2.start();
        this.enabled = true;
    }

    public void disable() {
        this.stop = true;
        this.enabled = false;
    }

    public void addThreadMonitor(@NotNull String threadName) {
        THREADS.add(threadName);
    }

    public long getUsedMemory() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    @NotNull
    public Map<String, ThreadResult> getResultMap() {
        return Collections.unmodifiableMap(this.resultMap);
    }

    @NotNull
    public Component getCpuMonitoringMessage() {
        if (!this.enabled) {
            return Component.text("CPU monitoring is disabled");
        }
        TextComponent.Builder benchmarkMessage = Component.text();
        for (Map.Entry<String, ThreadResult> resultEntry : this.resultMap.entrySet()) {
            String name2 = resultEntry.getKey();
            ThreadResult result2 = resultEntry.getValue();
            benchmarkMessage.append((Component)Component.text(name2, (TextColor)NamedTextColor.GRAY));
            benchmarkMessage.append((Component)Component.text(": "));
            benchmarkMessage.append((Component)Component.text(MathUtils.round(result2.getCpuPercentage(), 2), (TextColor)NamedTextColor.YELLOW));
            benchmarkMessage.append((Component)Component.text("% CPU ", (TextColor)NamedTextColor.YELLOW));
            benchmarkMessage.append((Component)Component.text(MathUtils.round(result2.getUserPercentage(), 2), (TextColor)NamedTextColor.RED));
            benchmarkMessage.append((Component)Component.text("% USER ", (TextColor)NamedTextColor.RED));
            benchmarkMessage.append((Component)Component.text(MathUtils.round(result2.getBlockedPercentage(), 2), (TextColor)NamedTextColor.LIGHT_PURPLE));
            benchmarkMessage.append((Component)Component.text("% BLOCKED ", (TextColor)NamedTextColor.LIGHT_PURPLE));
            benchmarkMessage.append((Component)Component.text(MathUtils.round(result2.getWaitedPercentage(), 2), (TextColor)NamedTextColor.GREEN));
            benchmarkMessage.append((Component)Component.text("% WAITED ", (TextColor)NamedTextColor.GREEN));
            benchmarkMessage.append((Component)Component.newline());
        }
        return benchmarkMessage.build();
    }

    private void refreshData() {
        ThreadInfo[] threadInfo;
        for (ThreadInfo threadInfo2 : threadInfo = THREAD_MX_BEAN.getThreadInfo(THREAD_MX_BEAN.getAllThreadIds())) {
            if (threadInfo2 == null) continue;
            String name2 = threadInfo2.getThreadName();
            if (THREADS.stream().noneMatch(name2::startsWith)) continue;
            long id2 = threadInfo2.getThreadId();
            long lastCpuTime = this.lastCpuTimeMap.getOrDefault(id2, 0L);
            long lastUserTime = this.lastUserTimeMap.getOrDefault(id2, 0L);
            long lastWaitedTime = this.lastWaitedMap.getOrDefault(id2, 0L);
            long lastBlockedTime = this.lastBlockedMap.getOrDefault(id2, 0L);
            long blockedTime = threadInfo2.getBlockedTime();
            long waitedTime = threadInfo2.getWaitedTime();
            long cpuTime = THREAD_MX_BEAN.getThreadCpuTime(id2);
            long userTime = THREAD_MX_BEAN.getThreadUserTime(id2);
            this.lastCpuTimeMap.put(id2, cpuTime);
            this.lastUserTimeMap.put(id2, userTime);
            this.lastWaitedMap.put(id2, waitedTime);
            this.lastBlockedMap.put(id2, blockedTime);
            double totalCpuTime = (double)(cpuTime - lastCpuTime) / 1000000.0;
            double totalUserTime = (double)(userTime - lastUserTime) / 1000000.0;
            long totalBlocked = blockedTime - lastBlockedTime;
            long totalWaited = waitedTime - lastWaitedTime;
            double cpuPercentage = totalCpuTime / (double)this.time * 100.0;
            double userPercentage = totalUserTime / (double)this.time * 100.0;
            double waitedPercentage = (double)totalWaited / (double)this.time * 100.0;
            double blockedPercentage = (double)totalBlocked / (double)this.time * 100.0;
            ThreadResult threadResult = new ThreadResult(cpuPercentage, userPercentage, waitedPercentage, blockedPercentage);
            this.resultMap.put(name2, threadResult);
        }
    }

    static {
        THREADS.add("Ms-TickScheduler");
        THREADS.add("Ms-Tick");
    }
}

