/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.listener.manager;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minestom.server.MinecraftServer;
import net.minestom.server.ServerProcess;
import net.minestom.server.entity.Player;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.player.PlayerPacketEvent;
import net.minestom.server.listener.AbilitiesListener;
import net.minestom.server.listener.AdvancementTabListener;
import net.minestom.server.listener.AnimationListener;
import net.minestom.server.listener.BlockPlacementListener;
import net.minestom.server.listener.BookListener;
import net.minestom.server.listener.ChatMessageListener;
import net.minestom.server.listener.CreativeInventoryActionListener;
import net.minestom.server.listener.EntityActionListener;
import net.minestom.server.listener.KeepAliveListener;
import net.minestom.server.listener.PlayerDiggingListener;
import net.minestom.server.listener.PlayerHeldListener;
import net.minestom.server.listener.PlayerPositionListener;
import net.minestom.server.listener.PlayerVehicleListener;
import net.minestom.server.listener.PluginMessageListener;
import net.minestom.server.listener.RecipeListener;
import net.minestom.server.listener.ResourcePackListener;
import net.minestom.server.listener.SettingsListener;
import net.minestom.server.listener.SpectateListener;
import net.minestom.server.listener.StatusListener;
import net.minestom.server.listener.TabCompleteListener;
import net.minestom.server.listener.UseEntityListener;
import net.minestom.server.listener.UseItemListener;
import net.minestom.server.listener.WindowListener;
import net.minestom.server.listener.manager.PacketListenerConsumer;
import net.minestom.server.network.packet.client.ClientPacket;
import net.minestom.server.network.packet.client.play.ClientAdvancementTabPacket;
import net.minestom.server.network.packet.client.play.ClientAnimationPacket;
import net.minestom.server.network.packet.client.play.ClientChatMessagePacket;
import net.minestom.server.network.packet.client.play.ClientClickWindowPacket;
import net.minestom.server.network.packet.client.play.ClientCloseWindowPacket;
import net.minestom.server.network.packet.client.play.ClientCommandChatPacket;
import net.minestom.server.network.packet.client.play.ClientCraftRecipeRequest;
import net.minestom.server.network.packet.client.play.ClientCreativeInventoryActionPacket;
import net.minestom.server.network.packet.client.play.ClientEditBookPacket;
import net.minestom.server.network.packet.client.play.ClientEntityActionPacket;
import net.minestom.server.network.packet.client.play.ClientHeldItemChangePacket;
import net.minestom.server.network.packet.client.play.ClientInteractEntityPacket;
import net.minestom.server.network.packet.client.play.ClientKeepAlivePacket;
import net.minestom.server.network.packet.client.play.ClientPlayerAbilitiesPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerBlockPlacementPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerDiggingPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerPositionAndRotationPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerPositionPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerRotationPacket;
import net.minestom.server.network.packet.client.play.ClientPluginMessagePacket;
import net.minestom.server.network.packet.client.play.ClientPongPacket;
import net.minestom.server.network.packet.client.play.ClientResourcePackStatusPacket;
import net.minestom.server.network.packet.client.play.ClientSettingsPacket;
import net.minestom.server.network.packet.client.play.ClientSpectatePacket;
import net.minestom.server.network.packet.client.play.ClientStatusPacket;
import net.minestom.server.network.packet.client.play.ClientSteerBoatPacket;
import net.minestom.server.network.packet.client.play.ClientSteerVehiclePacket;
import net.minestom.server.network.packet.client.play.ClientTabCompletePacket;
import net.minestom.server.network.packet.client.play.ClientTeleportConfirmPacket;
import net.minestom.server.network.packet.client.play.ClientUseItemPacket;
import net.minestom.server.network.packet.client.play.ClientVehicleMovePacket;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PacketListenerManager {
    public static final Logger LOGGER = LoggerFactory.getLogger(PacketListenerManager.class);
    private final ServerProcess serverProcess;
    private final Map<Class<? extends ClientPacket>, PacketListenerConsumer> listeners = new ConcurrentHashMap<Class<? extends ClientPacket>, PacketListenerConsumer>();

    public PacketListenerManager(ServerProcess serverProcess) {
        this.serverProcess = serverProcess;
        this.setListener(ClientKeepAlivePacket.class, KeepAliveListener::listener);
        this.setListener(ClientCommandChatPacket.class, ChatMessageListener::commandChatListener);
        this.setListener(ClientChatMessagePacket.class, ChatMessageListener::chatMessageListener);
        this.setListener(ClientClickWindowPacket.class, WindowListener::clickWindowListener);
        this.setListener(ClientCloseWindowPacket.class, WindowListener::closeWindowListener);
        this.setListener(ClientPongPacket.class, WindowListener::pong);
        this.setListener(ClientEntityActionPacket.class, EntityActionListener::listener);
        this.setListener(ClientHeldItemChangePacket.class, PlayerHeldListener::heldListener);
        this.setListener(ClientPlayerBlockPlacementPacket.class, BlockPlacementListener::listener);
        this.setListener(ClientSteerVehiclePacket.class, PlayerVehicleListener::steerVehicleListener);
        this.setListener(ClientVehicleMovePacket.class, PlayerVehicleListener::vehicleMoveListener);
        this.setListener(ClientSteerBoatPacket.class, PlayerVehicleListener::boatSteerListener);
        this.setListener(ClientPlayerPacket.class, PlayerPositionListener::playerPacketListener);
        this.setListener(ClientPlayerRotationPacket.class, PlayerPositionListener::playerLookListener);
        this.setListener(ClientPlayerPositionPacket.class, PlayerPositionListener::playerPositionListener);
        this.setListener(ClientPlayerPositionAndRotationPacket.class, PlayerPositionListener::playerPositionAndLookListener);
        this.setListener(ClientTeleportConfirmPacket.class, PlayerPositionListener::teleportConfirmListener);
        this.setListener(ClientPlayerDiggingPacket.class, PlayerDiggingListener::playerDiggingListener);
        this.setListener(ClientAnimationPacket.class, AnimationListener::animationListener);
        this.setListener(ClientInteractEntityPacket.class, UseEntityListener::useEntityListener);
        this.setListener(ClientUseItemPacket.class, UseItemListener::useItemListener);
        this.setListener(ClientStatusPacket.class, StatusListener::listener);
        this.setListener(ClientSettingsPacket.class, SettingsListener::listener);
        this.setListener(ClientCreativeInventoryActionPacket.class, CreativeInventoryActionListener::listener);
        this.setListener(ClientCraftRecipeRequest.class, RecipeListener::listener);
        this.setListener(ClientTabCompletePacket.class, TabCompleteListener::listener);
        this.setListener(ClientPluginMessagePacket.class, PluginMessageListener::listener);
        this.setListener(ClientPlayerAbilitiesPacket.class, AbilitiesListener::listener);
        this.setListener(ClientResourcePackStatusPacket.class, ResourcePackListener::listener);
        this.setListener(ClientAdvancementTabPacket.class, AdvancementTabListener::listener);
        this.setListener(ClientSpectatePacket.class, SpectateListener::listener);
        this.setListener(ClientEditBookPacket.class, BookListener::listener);
    }

    public <T extends ClientPacket> void processClientPacket(@NotNull T packet, @NotNull Player player) {
        Class<?> clazz = packet.getClass();
        PacketListenerConsumer packetListenerConsumer = this.listeners.get(clazz);
        if (packetListenerConsumer == null) {
            LOGGER.warn("Packet " + clazz + " does not have any default listener! (The issue comes from Minestom)");
        }
        PlayerPacketEvent playerPacketEvent = new PlayerPacketEvent(player, packet);
        EventDispatcher.call(playerPacketEvent);
        if (playerPacketEvent.isCancelled()) {
            return;
        }
        if (packetListenerConsumer != null) {
            try {
                packetListenerConsumer.accept(packet, player);
            }
            catch (Exception e) {
                MinecraftServer.getExceptionManager().handleException(e);
            }
        }
    }

    public <T extends ClientPacket> void setListener(@NotNull Class<T> packetClass, @NotNull PacketListenerConsumer<T> consumer) {
        this.listeners.put(packetClass, consumer);
    }
}

