/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.listener;

import net.minestom.server.coordinate.Pos;
import net.minestom.server.entity.Player;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.player.PlayerMoveEvent;
import net.minestom.server.instance.Instance;
import net.minestom.server.network.packet.client.play.ClientPlayerPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerPositionAndRotationPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerPositionPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerRotationPacket;
import net.minestom.server.network.packet.client.play.ClientTeleportConfirmPacket;
import net.minestom.server.network.packet.server.play.PlayerPositionAndLookPacket;
import net.minestom.server.utils.chunk.ChunkUtils;
import org.jetbrains.annotations.NotNull;

public class PlayerPositionListener {
    public static void playerPacketListener(ClientPlayerPacket packet, Player player) {
        player.refreshOnGround(packet.onGround());
    }

    public static void playerLookListener(ClientPlayerRotationPacket packet, Player player) {
        PlayerPositionListener.processMovement(player, player.getPosition().withView(packet.yaw(), packet.pitch()), packet.onGround());
    }

    public static void playerPositionListener(ClientPlayerPositionPacket packet, Player player) {
        PlayerPositionListener.processMovement(player, player.getPosition().withCoord(packet.position()), packet.onGround());
    }

    public static void playerPositionAndLookListener(ClientPlayerPositionAndRotationPacket packet, Player player) {
        PlayerPositionListener.processMovement(player, packet.position(), packet.onGround());
    }

    public static void teleportConfirmListener(ClientTeleportConfirmPacket packet, Player player) {
        player.refreshReceivedTeleportId(packet.teleportId());
    }

    private static void processMovement(@NotNull Player player, @NotNull Pos packetPosition, boolean onGround) {
        Pos currentPosition = player.getPosition();
        if (currentPosition.equals(packetPosition)) {
            return;
        }
        Instance instance = player.getInstance();
        if (instance == null) {
            return;
        }
        if (player.getLastSentTeleportId() != player.getLastReceivedTeleportId()) {
            return;
        }
        if (!currentPosition.sameChunk(packetPosition) && !ChunkUtils.isLoaded(instance, packetPosition)) {
            player.teleport(currentPosition);
            return;
        }
        PlayerMoveEvent playerMoveEvent = new PlayerMoveEvent(player, packetPosition, onGround);
        EventDispatcher.call(playerMoveEvent);
        if (!currentPosition.equals(player.getPosition())) {
            return;
        }
        if (playerMoveEvent.isCancelled()) {
            player.sendPacket(new PlayerPositionAndLookPacket(currentPosition, 0, player.getNextTeleportId(), false));
            return;
        }
        Pos eventPosition = playerMoveEvent.getNewPosition();
        if (packetPosition.equals(eventPosition)) {
            player.refreshPosition(eventPosition);
            player.refreshOnGround(onGround);
        } else if (packetPosition.samePoint(eventPosition)) {
            player.refreshPosition(eventPosition, true);
            player.refreshOnGround(onGround);
            player.setView(eventPosition.yaw(), eventPosition.pitch());
        } else {
            player.teleport(eventPosition);
        }
    }
}

