/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.metadata;

import java.util.List;
import net.minestom.server.color.Color;
import net.minestom.server.item.ItemMetaView;
import net.minestom.server.potion.CustomPotionEffect;
import net.minestom.server.potion.PotionType;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.tag.Tag;
import net.minestom.server.tag.TagHandler;
import net.minestom.server.tag.TagReadable;
import net.minestom.server.tag.TagSerializer;
import net.minestom.server.tag.TagWritable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public record PotionMeta(TagReadable readable) implements ItemMetaView<Builder>
{
    private static final Tag<PotionType> POTION_TYPE = Tag.String("Potion").map(PotionType::fromNamespaceId, ProtocolObject::name).defaultValue(PotionType.EMPTY);
    private static final Tag<List<CustomPotionEffect>> CUSTOM_POTION_EFFECTS = Tag.Structure("CustomPotionEffects", new TagSerializer<CustomPotionEffect>(){

        @Override
        @Nullable
        public CustomPotionEffect read(@NotNull TagReadable reader) {
            Byte id2 = reader.getTag(Tag.Byte("Id"));
            Byte amplifier = reader.getTag(Tag.Byte("Amplifier"));
            Integer duration = reader.getTag(Tag.Integer("Duration"));
            Boolean ambient = reader.getTag(Tag.Boolean("Ambient"));
            Boolean showParticles = reader.getTag(Tag.Boolean("ShowParticles"));
            Boolean showIcon = reader.getTag(Tag.Boolean("ShowIcon"));
            if (id2 == null || amplifier == null || duration == null || ambient == null || showParticles == null || showIcon == null) {
                return null;
            }
            return new CustomPotionEffect(id2, amplifier, duration, ambient, showParticles, showIcon);
        }

        @Override
        public void write(@NotNull TagWritable writer, @NotNull CustomPotionEffect value) {
            writer.setTag(Tag.Byte("Id"), value.id());
            writer.setTag(Tag.Byte("Amplifier"), value.amplifier());
            writer.setTag(Tag.Integer("Duration"), value.duration());
            writer.setTag(Tag.Boolean("Ambient"), value.isAmbient());
            writer.setTag(Tag.Boolean("ShowParticles"), value.showParticles());
            writer.setTag(Tag.Boolean("ShowIcon"), value.showIcon());
        }
    }).list().defaultValue(List.of());
    private static final Tag<Color> CUSTOM_POTION_COLOR = Tag.Integer("CustomPotionColor").path("display").map(Color::new, Color::asRGB);

    @NotNull
    public PotionType getPotionType() {
        return this.getTag(POTION_TYPE);
    }

    @NotNull
    public List<CustomPotionEffect> getCustomPotionEffects() {
        return this.getTag(CUSTOM_POTION_EFFECTS);
    }

    @Nullable
    public Color getColor() {
        return this.getTag(CUSTOM_POTION_COLOR);
    }

    @Override
    public <T> @UnknownNullability T getTag(@NotNull Tag<T> tag) {
        return this.readable.getTag(tag);
    }

    public record Builder(TagHandler tagHandler) implements ItemMetaView.Builder
    {
        public Builder() {
            this(TagHandler.newHandler());
        }

        public Builder potionType(@NotNull PotionType potionType) {
            this.setTag(POTION_TYPE, potionType);
            return this;
        }

        public Builder effects(@NotNull List<CustomPotionEffect> customPotionEffects) {
            this.setTag(CUSTOM_POTION_EFFECTS, customPotionEffects);
            return this;
        }

        public Builder color(@NotNull Color color) {
            this.setTag(CUSTOM_POTION_COLOR, color);
            return this;
        }
    }
}

