/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minestom.server.item.Enchantment;
import net.minestom.server.item.ItemMetaView;
import net.minestom.server.item.ItemSerializers;
import net.minestom.server.tag.Tag;
import net.minestom.server.tag.TagHandler;
import net.minestom.server.tag.TagReadable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

public record EnchantedBookMeta(TagReadable readable) implements ItemMetaView<Builder>
{
    static final Tag<Map<Enchantment, Short>> ENCHANTMENTS = Tag.Structure("StoredEnchantments", ItemSerializers.ENCHANTMENT_SERIALIZER).list().map(enchantmentEntry -> {
        HashMap<Enchantment, Short> map2 = new HashMap<Enchantment, Short>();
        for (ItemSerializers.EnchantmentEntry entry2 : enchantmentEntry) {
            map2.put(entry2.enchantment(), entry2.level());
        }
        return Map.copyOf(map2);
    }, o -> {
        ArrayList<ItemSerializers.EnchantmentEntry> entries2 = new ArrayList<ItemSerializers.EnchantmentEntry>();
        for (Map.Entry entry2 : o.entrySet()) {
            entries2.add(new ItemSerializers.EnchantmentEntry((Enchantment)entry2.getKey(), (Short)entry2.getValue()));
        }
        return List.copyOf(entries2);
    }).defaultValue(Map.of());

    @NotNull
    public Map<Enchantment, Short> getStoredEnchantmentMap() {
        return this.getTag(ENCHANTMENTS);
    }

    @Override
    public <T> @UnknownNullability T getTag(@NotNull Tag<T> tag) {
        return this.readable.getTag(tag);
    }

    public record Builder(TagHandler tagHandler) implements ItemMetaView.Builder
    {
        public Builder() {
            this(TagHandler.newHandler());
        }

        @Override
        @NotNull
        public Builder enchantments(@NotNull Map<Enchantment, Short> enchantments) {
            this.setTag(ENCHANTMENTS, Map.copyOf(enchantments));
            return this;
        }

        @Override
        @NotNull
        public Builder enchantment(@NotNull Enchantment enchantment, short level) {
            HashMap<Enchantment, Short> enchantments = new HashMap<Enchantment, Short>(this.getTag(ENCHANTMENTS));
            enchantments.put(enchantment, level);
            return this.enchantments(enchantments);
        }
    }
}

