/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.minestom.server.item.Enchantment;
import net.minestom.server.item.ItemSerializers;
import net.minestom.server.item.attribute.ItemAttribute;
import net.minestom.server.tag.Tag;

final class ItemTags {
    static final Tag<Integer> DAMAGE = Tag.Integer("Damage").defaultValue(0);
    static final Tag<Boolean> UNBREAKABLE = Tag.Boolean("Unbreakable").defaultValue(false);
    static final Tag<Integer> HIDE_FLAGS = Tag.Integer("HideFlags").defaultValue(0);
    static final Tag<Integer> CUSTOM_MODEL_DATA = Tag.Integer("CustomModelData").defaultValue(0);
    static final Tag<Component> NAME = Tag.Component("Name").path("display");
    static final Tag<List<Component>> LORE = Tag.Component("Lore").path("display").list().defaultValue(List.of());
    static final Tag<Map<Enchantment, Short>> ENCHANTMENTS = Tag.Structure("Enchantments", ItemSerializers.ENCHANTMENT_SERIALIZER).list().map(enchantmentEntry -> {
        HashMap<Enchantment, Short> map2 = new HashMap<Enchantment, Short>();
        for (ItemSerializers.EnchantmentEntry entry2 : enchantmentEntry) {
            map2.put(entry2.enchantment(), entry2.level());
        }
        return Map.copyOf(map2);
    }, o -> {
        ArrayList<ItemSerializers.EnchantmentEntry> entries2 = new ArrayList<ItemSerializers.EnchantmentEntry>();
        for (Map.Entry entry2 : o.entrySet()) {
            entries2.add(new ItemSerializers.EnchantmentEntry((Enchantment)entry2.getKey(), (Short)entry2.getValue()));
        }
        return List.copyOf(entries2);
    }).defaultValue(Map.of());
    static final Tag<List<ItemAttribute>> ATTRIBUTES = Tag.Structure("AttributeModifiers", ItemSerializers.ATTRIBUTE_SERIALIZER).list().defaultValue(List.of());
    static final Tag<List<String>> CAN_PLACE_ON = Tag.String("CanPlaceOn").list().defaultValue(List.of());
    static final Tag<List<String>> CAN_DESTROY = Tag.String("CanDestroy").list().defaultValue(List.of());

    ItemTags() {
    }
}

