/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.function.Consumer;
import net.minestom.server.item.ItemMeta;
import net.minestom.server.item.ItemMetaImpl;
import net.minestom.server.item.ItemMetaView;
import net.minestom.server.item.ItemMetaViewImpl;
import net.minestom.server.item.ItemStack;
import net.minestom.server.item.Material;
import net.minestom.server.item.StackingRule;
import net.minestom.server.item.rule.VanillaStackingRule;
import net.minestom.server.tag.Tag;
import net.minestom.server.tag.TagHandler;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTByte;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.NBTString;

final class ItemStackImpl
extends Record
implements ItemStack {
    private final Material material;
    private final int amount;
    private final ItemMetaImpl meta;
    @NotNull
    static final StackingRule DEFAULT_STACKING_RULE;

    ItemStackImpl(Material material, int amount, ItemMetaImpl meta) {
        this.material = material;
        this.amount = amount;
        this.meta = meta;
    }

    static ItemStack create(Material material, int amount, ItemMetaImpl meta) {
        if (amount <= 0) {
            return AIR;
        }
        return new ItemStackImpl(material, amount, meta);
    }

    static ItemStack create(Material material, int amount) {
        return ItemStackImpl.create(material, amount, ItemMetaImpl.EMPTY);
    }

    @Override
    @NotNull
    public <T extends ItemMetaView<?>> T meta(@NotNull Class<T> metaClass) {
        return ItemMetaViewImpl.construct(metaClass, this.meta);
    }

    @Override
    @NotNull
    public ItemStack with(@NotNull @NotNull Consumer<@NotNull ItemStack.Builder> consumer) {
        ItemStack.Builder builder = this.builder();
        consumer.accept(builder);
        return builder.build();
    }

    @Override
    @NotNull
    public <V extends ItemMetaView.Builder, T extends ItemMetaView<V>> ItemStack withMeta(@NotNull Class<T> metaType, @NotNull Consumer<V> consumer) {
        return this.builder().meta(metaType, consumer).build();
    }

    @Override
    @NotNull
    public ItemStack withMeta(@NotNull @NotNull Consumer<@NotNull ItemMeta.Builder> consumer) {
        return this.builder().meta(consumer).build();
    }

    @Override
    @NotNull
    public ItemStack withMaterial(@NotNull Material material) {
        return new ItemStackImpl(material, this.amount, this.meta);
    }

    @Override
    @NotNull
    public ItemStack withAmount(int amount) {
        return ItemStackImpl.create(this.material, amount, this.meta);
    }

    @Override
    @NotNull
    public ItemStack consume(int amount) {
        return DEFAULT_STACKING_RULE.apply((ItemStack)this, currentAmount -> currentAmount - amount);
    }

    @Override
    @NotNull
    public ItemStack withMeta(@NotNull ItemMeta meta) {
        return new ItemStackImpl(this.material, this.amount, (ItemMetaImpl)meta);
    }

    @Override
    public boolean isSimilar(@NotNull ItemStack itemStack) {
        return this.material == itemStack.material() && this.meta.equals(itemStack.meta());
    }

    @Override
    @NotNull
    public NBTCompound toItemNBT() {
        NBTString material = NBT.String(this.material().name());
        NBTByte amount = NBT.Byte(this.amount());
        NBTCompound nbt = this.meta().toNBT();
        if (nbt.isEmpty()) {
            return NBT.Compound(Map.of("id", material, "Count", amount));
        }
        return NBT.Compound(Map.of("id", material, "Count", amount, "tag", nbt));
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    private ItemStack.Builder builder() {
        return new Builder(this.material, this.amount, new ItemMetaImpl.Builder(this.meta.tagHandler().copy()));
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ItemStackImpl.class, "material;amount;meta", "material", "amount", "meta"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ItemStackImpl.class, "material;amount;meta", "material", "amount", "meta"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ItemStackImpl.class, "material;amount;meta", "material", "amount", "meta"}, this, o);
    }

    @Override
    public Material material() {
        return this.material;
    }

    @Override
    public int amount() {
        return this.amount;
    }

    @Override
    public ItemMetaImpl meta() {
        return this.meta;
    }

    static {
        String stackingRuleProperty = System.getProperty("minestom.stacking-rule");
        if (stackingRuleProperty == null) {
            DEFAULT_STACKING_RULE = new VanillaStackingRule();
        } else {
            try {
                DEFAULT_STACKING_RULE = (StackingRule)ClassLoader.getSystemClassLoader().loadClass(stackingRuleProperty).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instantiate default stacking rule", e);
            }
        }
    }

    static final class Builder
    implements ItemStack.Builder {
        final Material material;
        int amount;
        ItemMetaImpl.Builder metaBuilder;

        Builder(Material material, int amount, ItemMetaImpl.Builder metaBuilder) {
            this.material = material;
            this.amount = amount;
            this.metaBuilder = metaBuilder;
        }

        Builder(Material material, int amount) {
            this(material, amount, new ItemMetaImpl.Builder(TagHandler.newHandler()));
        }

        @Override
        public @NotNull ItemStack.Builder amount(int amount) {
            this.amount = amount;
            return this;
        }

        @Override
        public @NotNull ItemStack.Builder meta(@NotNull TagHandler tagHandler) {
            return this.metaBuilder(new ItemMetaImpl.Builder(tagHandler.copy()));
        }

        @Override
        public @NotNull ItemStack.Builder meta(@NotNull NBTCompound compound) {
            return this.metaBuilder(new ItemMetaImpl.Builder(TagHandler.fromCompound(compound)));
        }

        @Override
        public @NotNull ItemStack.Builder meta(@NotNull ItemMeta itemMeta) {
            TagHandler tagHandler = ((ItemMetaImpl)itemMeta).tagHandler();
            return this.metaBuilder(new ItemMetaImpl.Builder(tagHandler.copy()));
        }

        @Override
        public @NotNull ItemStack.Builder meta(@NotNull Consumer<ItemMeta.Builder> consumer) {
            consumer.accept(this.metaBuilder);
            return this;
        }

        @Override
        public <V extends ItemMetaView.Builder, T extends ItemMetaView<V>> @NotNull ItemStack.Builder meta(@NotNull Class<T> metaType, @NotNull @NotNull Consumer<@NotNull V> itemMetaConsumer) {
            Object view = ItemMetaViewImpl.constructBuilder(metaType, this.metaBuilder.tagHandler());
            itemMetaConsumer.accept(view);
            return this;
        }

        @Override
        public <T> void setTag(@NotNull Tag<T> tag, @Nullable T value) {
            this.metaBuilder.setTag(tag, value);
        }

        @Override
        @NotNull
        public ItemStack build() {
            return ItemStackImpl.create(this.material, this.amount, this.metaBuilder.build());
        }

        private @NotNull ItemStack.Builder metaBuilder(@NotNull ItemMetaImpl.Builder builder) {
            this.metaBuilder = builder;
            return this;
        }
    }
}

