/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item;

import java.util.Locale;
import java.util.UUID;
import net.minestom.server.attribute.Attribute;
import net.minestom.server.attribute.AttributeOperation;
import net.minestom.server.item.Enchantment;
import net.minestom.server.item.attribute.AttributeSlot;
import net.minestom.server.item.attribute.ItemAttribute;
import net.minestom.server.tag.Tag;
import net.minestom.server.tag.TagReadable;
import net.minestom.server.tag.TagSerializer;
import net.minestom.server.tag.TagWritable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ItemSerializers {
    public static final TagSerializer<EnchantmentEntry> ENCHANTMENT_SERIALIZER = new TagSerializer<EnchantmentEntry>(){
        static final Tag<Short> LEVEL = Tag.Short("lvl");
        static final Tag<String> ID = Tag.String("id");

        @Override
        @Nullable
        public EnchantmentEntry read(@NotNull TagReadable reader) {
            String id2 = reader.getTag(ID);
            Short level = reader.getTag(LEVEL);
            if (id2 == null || level == null) {
                return null;
            }
            Enchantment enchantment = Enchantment.fromNamespaceId(id2);
            return new EnchantmentEntry(enchantment, level);
        }

        @Override
        public void write(@NotNull TagWritable writer, @NotNull EnchantmentEntry value) {
            writer.setTag(ID, value.enchantment.name());
            writer.setTag(LEVEL, value.level);
        }
    };
    static final TagSerializer<ItemAttribute> ATTRIBUTE_SERIALIZER = new TagSerializer<ItemAttribute>(){
        static final Tag<UUID> ID = Tag.UUID("UUID");
        static final Tag<Double> AMOUNT = Tag.Double("Amount");
        static final Tag<String> SLOT = Tag.String("Slot").defaultValue("mainhand");
        static final Tag<String> ATTRIBUTE_NAME = Tag.String("AttributeName");
        static final Tag<Integer> OPERATION = Tag.Integer("Operation");
        static final Tag<String> NAME = Tag.String("Name");

        @Override
        @Nullable
        public ItemAttribute read(@NotNull TagReadable reader) {
            AttributeSlot attributeSlot;
            UUID uuid = reader.getTag(ID);
            double amount = reader.getTag(AMOUNT);
            String slot = reader.getTag(SLOT);
            String attributeName = reader.getTag(ATTRIBUTE_NAME);
            int operation = reader.getTag(OPERATION);
            String name2 = reader.getTag(NAME);
            Attribute attribute = Attribute.fromKey(attributeName.toUpperCase(Locale.ROOT));
            if (attribute == null) {
                return null;
            }
            AttributeOperation attributeOperation = AttributeOperation.fromId(operation);
            if (attributeOperation == null) {
                return null;
            }
            try {
                attributeSlot = AttributeSlot.valueOf(slot.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                attributeSlot = AttributeSlot.MAINHAND;
            }
            return new ItemAttribute(uuid, name2, attribute, attributeOperation, amount, attributeSlot);
        }

        @Override
        public void write(@NotNull TagWritable writer, @NotNull ItemAttribute value) {
            writer.setTag(ID, value.uuid());
            writer.setTag(AMOUNT, value.amount());
            writer.setTag(SLOT, value.slot().name().toLowerCase(Locale.ROOT));
            writer.setTag(ATTRIBUTE_NAME, value.attribute().key());
            writer.setTag(OPERATION, value.operation().getId());
            writer.setTag(NAME, value.name());
        }
    };

    public record EnchantmentEntry(Enchantment enchantment, short level) {
    }
}

