/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.inventory.type;

import net.kyori.adventure.text.Component;
import net.minestom.server.inventory.Inventory;
import net.minestom.server.inventory.InventoryProperty;
import net.minestom.server.inventory.InventoryType;
import net.minestom.server.item.Enchantment;
import org.jetbrains.annotations.NotNull;

public class EnchantmentTableInventory
extends Inventory {
    private final short[] levelRequirements = new short[EnchantmentSlot.values().length];
    private short seed;
    private final short[] enchantmentShown = new short[EnchantmentSlot.values().length];
    private final short[] enchantmentLevel = new short[EnchantmentSlot.values().length];

    public EnchantmentTableInventory(@NotNull Component title) {
        super(InventoryType.ENCHANTMENT, title);
    }

    public EnchantmentTableInventory(@NotNull String title) {
        super(InventoryType.ENCHANTMENT, title);
    }

    public short getLevelRequirement(EnchantmentSlot enchantmentSlot) {
        return this.levelRequirements[enchantmentSlot.ordinal()];
    }

    public void setLevelRequirement(EnchantmentSlot enchantmentSlot, short level) {
        switch (enchantmentSlot) {
            case TOP: {
                this.sendProperty(InventoryProperty.ENCHANTMENT_TABLE_LEVEL_REQUIREMENT_TOP, level);
                break;
            }
            case MIDDLE: {
                this.sendProperty(InventoryProperty.ENCHANTMENT_TABLE_LEVEL_REQUIREMENT_MIDDLE, level);
                break;
            }
            case BOTTOM: {
                this.sendProperty(InventoryProperty.ENCHANTMENT_TABLE_LEVEL_REQUIREMENT_BOTTOM, level);
            }
        }
        this.levelRequirements[enchantmentSlot.ordinal()] = level;
    }

    public short getSeed() {
        return this.seed;
    }

    public void setSeed(short seed) {
        this.seed = seed;
        this.sendProperty(InventoryProperty.ENCHANTMENT_TABLE_SEED, seed);
    }

    public Enchantment getEnchantmentShown(EnchantmentSlot enchantmentSlot) {
        short id2 = this.enchantmentShown[enchantmentSlot.ordinal()];
        if (id2 == -1) {
            return null;
        }
        return Enchantment.fromId(id2);
    }

    public void setEnchantmentShown(EnchantmentSlot enchantmentSlot, Enchantment enchantment) {
        short id2 = enchantment == null ? (short)-1 : (short)enchantment.id();
        switch (enchantmentSlot) {
            case TOP: {
                this.sendProperty(InventoryProperty.ENCHANTMENT_TABLE_ENCH_ID_TOP, id2);
                break;
            }
            case MIDDLE: {
                this.sendProperty(InventoryProperty.ENCHANTMENT_TABLE_ENCH_ID_MIDDLE, id2);
                break;
            }
            case BOTTOM: {
                this.sendProperty(InventoryProperty.ENCHANTMENT_TABLE_ENCH_ID_BOTTOM, id2);
            }
        }
        this.enchantmentShown[enchantmentSlot.ordinal()] = id2;
    }

    public short getEnchantmentLevel(EnchantmentSlot enchantmentSlot) {
        return this.enchantmentLevel[enchantmentSlot.ordinal()];
    }

    public void setEnchantmentLevel(EnchantmentSlot enchantmentSlot, short level) {
        switch (enchantmentSlot) {
            case TOP: {
                this.sendProperty(InventoryProperty.ENCHANTMENT_TABLE_ENCH_LEVEL_TOP, level);
                break;
            }
            case MIDDLE: {
                this.sendProperty(InventoryProperty.ENCHANTMENT_TABLE_ENCH_LEVEL_MIDDLE, level);
                break;
            }
            case BOTTOM: {
                this.sendProperty(InventoryProperty.ENCHANTMENT_TABLE_ENCH_LEVEL_BOTTOM, level);
            }
        }
        this.enchantmentLevel[enchantmentSlot.ordinal()] = level;
    }

    public static enum EnchantmentSlot {
        TOP,
        MIDDLE,
        BOTTOM;

    }
}

