/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.inventory.click;

import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import net.minestom.server.entity.EquipmentSlot;
import net.minestom.server.entity.Player;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.inventory.InventoryClickEvent;
import net.minestom.server.event.inventory.InventoryPreClickEvent;
import net.minestom.server.inventory.AbstractInventory;
import net.minestom.server.inventory.Inventory;
import net.minestom.server.inventory.PlayerInventory;
import net.minestom.server.inventory.TransactionType;
import net.minestom.server.inventory.click.ClickType;
import net.minestom.server.inventory.click.InventoryClickResult;
import net.minestom.server.inventory.condition.InventoryCondition;
import net.minestom.server.inventory.condition.InventoryConditionResult;
import net.minestom.server.item.ItemStack;
import net.minestom.server.item.Material;
import net.minestom.server.item.StackingRule;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class InventoryClickProcessor {
    private final Map<Player, List<DragData>> leftDraggingMap = new ConcurrentHashMap<Player, List<DragData>>();
    private final Map<Player, List<DragData>> rightDraggingMap = new ConcurrentHashMap<Player, List<DragData>>();

    @NotNull
    public InventoryClickResult leftClick(@NotNull Player player, @NotNull AbstractInventory inventory, int slot, @NotNull ItemStack clicked, @NotNull ItemStack cursor) {
        InventoryClickResult result2 = this.startCondition(player, inventory, slot, ClickType.LEFT_CLICK, clicked, cursor);
        if (result2.isCancel()) {
            return result2;
        }
        clicked = result2.getClicked();
        cursor = result2.getCursor();
        StackingRule rule = StackingRule.get();
        if (rule.canBeStacked(cursor, clicked)) {
            int totalAmount = rule.getAmount(cursor) + rule.getAmount(clicked);
            int maxSize = rule.getMaxSize(cursor);
            if (!rule.canApply(clicked, totalAmount)) {
                result2.setCursor(rule.apply(cursor, totalAmount - maxSize));
                result2.setClicked(rule.apply(clicked, maxSize));
            } else {
                result2.setCursor(rule.apply(cursor, 0));
                result2.setClicked(rule.apply(clicked, totalAmount));
            }
        } else {
            result2.setCursor(clicked);
            result2.setClicked(cursor);
        }
        return result2;
    }

    @NotNull
    public InventoryClickResult rightClick(@NotNull Player player, @NotNull AbstractInventory inventory, int slot, @NotNull ItemStack clicked, @NotNull ItemStack cursor) {
        InventoryClickResult result2 = this.startCondition(player, inventory, slot, ClickType.RIGHT_CLICK, clicked, cursor);
        if (result2.isCancel()) {
            return result2;
        }
        clicked = result2.getClicked();
        cursor = result2.getCursor();
        StackingRule rule = StackingRule.get();
        if (rule.canBeStacked(clicked, cursor)) {
            int amount = rule.getAmount(clicked) + 1;
            if (!rule.canApply(clicked, amount)) {
                return result2;
            }
            result2.setCursor(rule.apply(cursor, operand -> operand - 1));
            result2.setClicked(rule.apply(clicked, amount));
        } else if (cursor.isAir()) {
            int amount = (int)Math.ceil((double)rule.getAmount(clicked) / 2.0);
            result2.setCursor(rule.apply(clicked, amount));
            result2.setClicked(rule.apply(clicked, operand -> operand / 2));
        } else if (clicked.isAir()) {
            result2.setCursor(rule.apply(cursor, operand -> operand - 1));
            result2.setClicked(rule.apply(cursor, 1));
        } else {
            result2.setCursor(clicked);
            result2.setClicked(cursor);
        }
        return result2;
    }

    @NotNull
    public InventoryClickResult changeHeld(@NotNull Player player, @NotNull AbstractInventory inventory, int slot, int key, @NotNull ItemStack clicked, @NotNull ItemStack cursor) {
        InventoryClickResult clickResult = this.startCondition(player, inventory, slot, ClickType.CHANGE_HELD, clicked, cursor);
        if (clickResult.isCancel()) {
            return clickResult;
        }
        clickResult = this.startCondition(player, player.getInventory(), key, ClickType.CHANGE_HELD, clicked, cursor);
        if (clickResult.isCancel()) {
            return clickResult;
        }
        clickResult.setClicked(cursor);
        clickResult.setCursor(clicked);
        return clickResult;
    }

    @NotNull
    public InventoryClickResult shiftClick(@NotNull AbstractInventory inventory, @NotNull AbstractInventory targetInventory, int start, int end, int step, @NotNull Player player, int slot, @NotNull ItemStack clicked, @NotNull ItemStack cursor) {
        ItemStack currentArmor;
        Material material;
        EquipmentSlot equipmentSlot;
        InventoryClickResult clickResult = this.startCondition(player, inventory, slot, ClickType.START_SHIFT_CLICK, clicked, cursor);
        if (clickResult.isCancel()) {
            return clickResult;
        }
        if (clicked.isAir()) {
            return clickResult.cancelled();
        }
        if (inventory instanceof PlayerInventory && targetInventory instanceof PlayerInventory && (equipmentSlot = (material = clicked.material()).registry().equipmentSlot()) != null && (currentArmor = player.getEquipment(equipmentSlot)).isAir()) {
            int armorSlot = equipmentSlot.armorSlot();
            InventoryClickResult result2 = this.startCondition(player, targetInventory, armorSlot, ClickType.SHIFT_CLICK, clicked, cursor);
            if (result2.isCancel()) {
                return clickResult;
            }
            result2.setClicked(ItemStack.AIR);
            result2.setCursor(cursor);
            player.setEquipment(equipmentSlot, clicked);
            return result2;
        }
        clickResult.setCancel(true);
        Pair<ItemStack, Map<Integer, ItemStack>> pair = TransactionType.ADD.process(targetInventory, clicked, (index, itemStack) -> {
            if (inventory == targetInventory && index == slot) {
                return false;
            }
            InventoryClickResult result2 = this.startCondition(player, targetInventory, index, ClickType.SHIFT_CLICK, itemStack, cursor);
            if (result2.isCancel()) {
                return false;
            }
            clickResult.setCancel(false);
            return true;
        }, start, end, step);
        ItemStack itemResult = pair.left();
        Map<Integer, ItemStack> itemChangesMap = pair.right();
        itemChangesMap.forEach((s2, itemStack) -> {
            targetInventory.setItemStack((int)s2, (ItemStack)itemStack);
            this.callClickEvent(player, targetInventory, (int)s2, ClickType.SHIFT_CLICK, (ItemStack)itemStack, cursor);
        });
        clickResult.setClicked(itemResult);
        return clickResult;
    }

    @Nullable
    public InventoryClickResult dragging(@NotNull Player player, @Nullable AbstractInventory inventory, int slot, int button, @NotNull ItemStack clicked, @NotNull ItemStack cursor) {
        InventoryClickResult clickResult = null;
        StackingRule stackingRule = StackingRule.get();
        if (slot != -999) {
            if (button == 1) {
                List<DragData> left = this.leftDraggingMap.get(player);
                if (left == null) {
                    return null;
                }
                left.add(new DragData(slot, inventory));
            } else if (button == 5) {
                List<DragData> right = this.rightDraggingMap.get(player);
                if (right == null) {
                    return null;
                }
                right.add(new DragData(slot, inventory));
            } else if (button == 9) {
                // empty if block
            }
        } else if (button == 0) {
            clickResult = this.startCondition(player, inventory, slot, ClickType.START_LEFT_DRAGGING, clicked, cursor);
            if (!clickResult.isCancel()) {
                this.leftDraggingMap.put(player, new ArrayList());
            }
        } else if (button == 2) {
            int cursorAmount;
            List<DragData> slots = this.leftDraggingMap.remove(player);
            if (slots == null) {
                return null;
            }
            int slotCount = slots.size();
            if (slotCount > (cursorAmount = stackingRule.getAmount(cursor))) {
                return null;
            }
            for (DragData s2 : slots) {
                ItemStack slotItem = s2.inventory.getItemStack(s2.slot);
                clickResult = this.startCondition(player, s2.inventory, s2.slot, ClickType.LEFT_DRAGGING, slotItem, cursor);
                if (!clickResult.isCancel()) continue;
                return clickResult;
            }
            clickResult = this.startCondition(player, inventory, slot, ClickType.END_LEFT_DRAGGING, clicked, cursor);
            if (clickResult.isCancel()) {
                return clickResult;
            }
            int slotSize = (int)((float)cursorAmount / (float)slotCount);
            int finalCursorAmount = cursorAmount;
            for (DragData dragData : slots) {
                AbstractInventory inv = dragData.inventory;
                int s3 = dragData.slot;
                ItemStack slotItem = inv.getItemStack(s3);
                int amount = stackingRule.getAmount(slotItem);
                if (stackingRule.canBeStacked(cursor, slotItem)) {
                    if (stackingRule.canApply(slotItem, amount + slotSize)) {
                        slotItem = stackingRule.apply(slotItem, a -> a + slotSize);
                        finalCursorAmount -= slotSize;
                    } else {
                        int maxSize = stackingRule.getMaxSize(cursor);
                        int removedAmount = maxSize - amount;
                        slotItem = stackingRule.apply(slotItem, maxSize);
                        finalCursorAmount -= removedAmount;
                    }
                } else if (slotItem.isAir()) {
                    slotItem = stackingRule.apply(cursor, slotSize);
                    finalCursorAmount -= slotSize;
                }
                inv.setItemStack(s3, slotItem);
                this.callClickEvent(player, inv, s3, ClickType.LEFT_DRAGGING, slotItem, cursor);
            }
            clickResult.setCursor(stackingRule.apply(cursor, finalCursorAmount));
        } else if (button == 4) {
            clickResult = this.startCondition(player, inventory, slot, ClickType.START_RIGHT_DRAGGING, clicked, cursor);
            if (!clickResult.isCancel()) {
                this.rightDraggingMap.put(player, new ArrayList());
            }
        } else if (button == 6) {
            int cursorAmount;
            List<DragData> slots = this.rightDraggingMap.remove(player);
            if (slots == null) {
                return null;
            }
            int size = slots.size();
            if (size > (cursorAmount = stackingRule.getAmount(cursor))) {
                return null;
            }
            for (DragData s4 : slots) {
                ItemStack slotItem = s4.inventory.getItemStack(s4.slot);
                clickResult = this.startCondition(player, s4.inventory, s4.slot, ClickType.RIGHT_DRAGGING, slotItem, cursor);
                if (!clickResult.isCancel()) continue;
                return clickResult;
            }
            clickResult = this.startCondition(player, inventory, slot, ClickType.END_RIGHT_DRAGGING, clicked, cursor);
            if (clickResult.isCancel()) {
                return clickResult;
            }
            int finalCursorAmount = cursorAmount;
            for (DragData dragData : slots) {
                AbstractInventory inv = dragData.inventory;
                int s5 = dragData.slot;
                ItemStack slotItem = inv.getItemStack(s5);
                if (stackingRule.canBeStacked(cursor, slotItem)) {
                    int amount = stackingRule.getAmount(slotItem) + 1;
                    if (stackingRule.canApply(slotItem, amount)) {
                        slotItem = stackingRule.apply(slotItem, amount);
                        --finalCursorAmount;
                    }
                } else if (slotItem.isAir()) {
                    slotItem = stackingRule.apply(cursor, 1);
                    --finalCursorAmount;
                }
                inv.setItemStack(s5, slotItem);
                this.callClickEvent(player, inv, s5, ClickType.RIGHT_DRAGGING, slotItem, cursor);
            }
            clickResult.setCursor(stackingRule.apply(cursor, finalCursorAmount));
        }
        return clickResult;
    }

    @NotNull
    public InventoryClickResult doubleClick(@NotNull AbstractInventory clickedInventory, @NotNull AbstractInventory inventory, @NotNull Player player, int slot, @NotNull ItemStack clicked, @NotNull ItemStack cursor) {
        InventoryClickResult clickResult = this.startCondition(player, clickedInventory, slot, ClickType.START_DOUBLE_CLICK, clicked, cursor);
        if (clickResult.isCancel()) {
            return clickResult;
        }
        if (cursor.isAir()) {
            return clickResult.cancelled();
        }
        StackingRule rule = StackingRule.get();
        int amount = rule.getAmount(cursor);
        int maxSize = rule.getMaxSize(cursor);
        int remainingAmount = maxSize - amount;
        if (remainingAmount == 0) {
            return clickResult;
        }
        BiFunction<AbstractInventory, ItemStack, ItemStack> func = (inv, rest) -> {
            Pair<ItemStack, Map<Integer, ItemStack>> pair = TransactionType.TAKE.process((AbstractInventory)inv, (ItemStack)rest, (index, itemStack) -> {
                if (index == slot) {
                    return false;
                }
                InventoryClickResult result2 = this.startCondition(player, (AbstractInventory)inv, index, ClickType.DOUBLE_CLICK, itemStack, cursor);
                return !result2.isCancel();
            });
            ItemStack itemResult = pair.left();
            Map<Integer, ItemStack> itemChangesMap = pair.right();
            itemChangesMap.forEach((s2, itemStack) -> {
                inv.setItemStack((int)s2, (ItemStack)itemStack);
                this.callClickEvent(player, (AbstractInventory)inv, (int)s2, ClickType.DOUBLE_CLICK, (ItemStack)itemStack, cursor);
            });
            return itemResult;
        };
        ItemStack remain = rule.apply(cursor, remainingAmount);
        PlayerInventory playerInventory = player.getInventory();
        if (Objects.equals(clickedInventory, inventory)) {
            if (!(remain = func.apply(inventory, remain)).isAir()) {
                remain = func.apply(playerInventory, remain);
            }
        } else if (clickedInventory == playerInventory) {
            if (!(remain = func.apply(playerInventory, remain)).isAir()) {
                remain = func.apply(inventory, remain);
            }
        } else {
            remain = func.apply(playerInventory, remain);
        }
        if (remain.isAir()) {
            clickResult.setCursor(rule.apply(cursor, maxSize));
        } else {
            int tookAmount = remainingAmount - rule.getAmount(remain);
            clickResult.setCursor(rule.apply(cursor, amount + tookAmount));
        }
        return clickResult;
    }

    @NotNull
    public InventoryClickResult drop(@NotNull Player player, @NotNull AbstractInventory inventory, boolean all, int slot, int button, @NotNull ItemStack clicked, @NotNull ItemStack cursor) {
        InventoryClickResult clickResult = this.startCondition(player, inventory, slot, ClickType.DROP, clicked, cursor);
        if (clickResult.isCancel()) {
            return clickResult;
        }
        StackingRule rule = StackingRule.get();
        ItemStack resultClicked = clicked;
        ItemStack resultCursor = cursor;
        if (slot == -999) {
            if (button == 0) {
                int amount = rule.getAmount(resultCursor);
                ItemStack dropItem = rule.apply(resultCursor, amount);
                boolean dropResult = player.dropItem(dropItem);
                clickResult.setCancel(!dropResult);
                if (dropResult) {
                    resultCursor = rule.apply(resultCursor, 0);
                }
            } else if (button == 1) {
                ItemStack dropItem = rule.apply(resultCursor, 1);
                boolean dropResult = player.dropItem(dropItem);
                clickResult.setCancel(!dropResult);
                if (dropResult) {
                    int amount = rule.getAmount(resultCursor);
                    int newAmount = amount - 1;
                    resultCursor = rule.apply(resultCursor, newAmount);
                }
            }
        } else if (!all) {
            if (button == 0) {
                ItemStack dropItem = rule.apply(resultClicked, 1);
                boolean dropResult = player.dropItem(dropItem);
                clickResult.setCancel(!dropResult);
                if (dropResult) {
                    int amount = rule.getAmount(resultClicked);
                    int newAmount = amount - 1;
                    resultClicked = rule.apply(resultClicked, newAmount);
                }
            } else if (button == 1) {
                int amount = rule.getAmount(resultClicked);
                ItemStack dropItem = rule.apply(resultClicked, amount);
                boolean dropResult = player.dropItem(dropItem);
                clickResult.setCancel(!dropResult);
                if (dropResult) {
                    resultClicked = rule.apply(resultClicked, 0);
                }
            }
        }
        clickResult.setClicked(resultClicked);
        clickResult.setCursor(resultCursor);
        return clickResult;
    }

    @NotNull
    private InventoryClickResult startCondition(@NotNull Player player, @Nullable AbstractInventory inventory, int slot, @NotNull ClickType clickType, @NotNull ItemStack clicked, @NotNull ItemStack cursor) {
        List<InventoryCondition> inventoryConditions;
        InventoryClickResult clickResult = new InventoryClickResult(clicked, cursor);
        Inventory eventInventory = inventory instanceof Inventory ? (Inventory)inventory : null;
        player.UNSAFE_changeDidCloseInventory(false);
        InventoryPreClickEvent inventoryPreClickEvent = new InventoryPreClickEvent(eventInventory, player, slot, clickType, clickResult.getClicked(), clickResult.getCursor());
        EventDispatcher.call(inventoryPreClickEvent);
        clickResult.setCursor(inventoryPreClickEvent.getCursorItem());
        clickResult.setClicked(inventoryPreClickEvent.getClickedItem());
        if (inventoryPreClickEvent.isCancelled()) {
            clickResult.setCancel(true);
        }
        if (inventory != null && !(inventoryConditions = inventory.getInventoryConditions()).isEmpty()) {
            for (InventoryCondition inventoryCondition : inventoryConditions) {
                InventoryConditionResult result2 = new InventoryConditionResult(clickResult.getClicked(), clickResult.getCursor());
                inventoryCondition.accept(player, slot, clickType, result2);
                clickResult.setCursor(result2.getCursorItem());
                clickResult.setClicked(result2.getClickedItem());
                if (!result2.isCancel()) continue;
                clickResult.setCancel(true);
            }
            if (player.didCloseInventory()) {
                clickResult.setCancel(true);
                player.UNSAFE_changeDidCloseInventory(false);
            }
        }
        return clickResult;
    }

    private void callClickEvent(@NotNull Player player, @Nullable AbstractInventory inventory, int slot, @NotNull ClickType clickType, @NotNull ItemStack clicked, @NotNull ItemStack cursor) {
        Inventory eventInventory = inventory instanceof Inventory ? (Inventory)inventory : null;
        EventDispatcher.call(new InventoryClickEvent(eventInventory, player, slot, clickType, clicked, cursor));
    }

    public void clearCache(@NotNull Player player) {
        this.leftDraggingMap.remove(player);
        this.rightDraggingMap.remove(player);
    }

    private record DragData(int slot, AbstractInventory inventory) {
    }
}

